<?php
// templates/components/skeletons.php
?>
<style>
    .skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #f8f8f8 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: shimmer 1.5s infinite;
    }
    @keyframes shimmer {
        0% { background-position: 200% 0; }
        100% { background-position: -200% 0; }
    }
</style>

<?php
// Function to render Product Card Skeleton
function renderProductSkeleton($count = 4) {
    for($i=0; $i<$count; $i++): ?>
        <div class="skeleton-loader bg-white rounded-2xl p-3 shadow-sm border border-gray-50">
            <div class="skeleton w-full aspect-[3/4] rounded-xl mb-3"></div>
            <div class="skeleton h-4 w-3/4 rounded mb-2"></div>
            <div class="skeleton h-3 w-1/2 rounded mb-3"></div>
            <div class="flex justify-between items-center">
                <div class="skeleton h-5 w-1/3 rounded"></div>
                <div class="skeleton h-8 w-8 rounded-full"></div>
            </div>
        </div>
    <?php endfor;
}

// Function to render List Item Skeleton (Orders/Transactions)
function renderListSkeleton($count = 3) {
    for($i=0; $i<$count; $i++): ?>
        <div class="skeleton-loader flex items-center gap-4 bg-white p-4 rounded-xl shadow-sm mb-3">
            <div class="skeleton w-12 h-12 rounded-full flex-shrink-0"></div>
            <div class="flex-1">
                <div class="skeleton h-4 w-3/4 rounded mb-2"></div>
                <div class="skeleton h-3 w-1/2 rounded"></div>
            </div>
            <div class="skeleton h-5 w-16 rounded"></div>
        </div>
    <?php endfor;
}
?>
<script src="<?php echo APP_URL; ?>/assets/js/skeleton.js"></script>
