<?php
// templates/components/popup-modal.php
?>
<!-- Global Popup Overlay -->
<div id="popupOverlay" class="fixed inset-0 bg-black/40 backdrop-blur-sm z-[9999] hidden opacity-0 transition-opacity duration-300 flex items-center justify-center p-4">
    
    <!-- Modal Card -->
    <div id="popupModal" class="bg-white w-full max-w-sm rounded-[2rem] p-6 shadow-2xl scale-90 opacity-0 transition-all duration-300 transform">
        
        <!-- Icon -->
        <div id="popupIcon" class="w-16 h-16 rounded-full flex items-center justify-center mb-4 mx-auto bg-rose-100">
            <!-- Dynamic Icon Here -->
        </div>

        <!-- Text -->
        <h3 id="popupTitle" class="text-xl font-bold text-center text-gray-900 mb-2">Title</h3>
        <div id="popupMessage" class="text-center text-gray-600 text-sm mb-8 leading-relaxed">
            Message goes here...
        </div>

        <!-- Buttons -->
        <div class="flex gap-3">
            <button id="popupCancel" class="hidden flex-1 py-3 rounded-xl font-bold text-gray-500 bg-gray-100 active:scale-95 transition-transform">
                Cancel
            </button>
            <button id="popupConfirm" class="w-full py-3 rounded-xl font-bold text-white bg-rose-500 shadow-lg shadow-rose-200 active:scale-95 transition-transform">
                Okay
            </button>
        </div>

    </div>
</div>

<script src="<?php echo APP_URL; ?>/assets/js/popup.js"></script>
