<?php
// templates/components/header.php
$isLoggedIn = isset($_SESSION['user_id']);
$userName = $_SESSION['user_name'] ?? 'Guest';
?>
<!-- Sticky Header -->
<header class="fixed top-0 left-0 w-full z-40 bg-[#FFF7F2]/90 backdrop-blur-md shadow-sm transition-all duration-300" id="mainHeader">
    <div class="px-4 py-3 flex items-center justify-between">
        
        <!-- Left: Logo & Greeting -->
        <div class="flex items-center gap-3">
             <!-- Drawer Toggle (Mobile) -->
            <button class="md:hidden text-gray-800">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h8m-8 6h16"></path></svg>
            </button>
            
            <a href="<?php echo APP_URL; ?>/user/home.php" class="flex flex-col">
                <span class="font-bold text-xl tracking-tighter text-gray-900 leading-none"><?php echo SITE_NAME; ?></span>
                <?php if($isLoggedIn): ?>
                <span class="text-[10px] text-[#D4AF37] font-bold uppercase tracking-widest">Hello, <?php echo explode(' ', $userName)[0]; ?></span>
                <?php endif; ?>
            </a>
        </div>

        <!-- Right: Actions -->
        <div class="flex items-center gap-4">
            <!-- Search -->
            <a href="<?php echo APP_URL; ?>/user/search.php" class="text-gray-600 hover:text-rose-500 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
            </a>

            <!-- Wishlist -->
            <a href="<?php echo APP_URL; ?>/user/wishlist.php" class="relative text-gray-600 hover:text-rose-500 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path></svg>
                <!-- Badge Placeholder (can be dynamic) -->
                <!-- <span class="absolute -top-1 -right-1 w-4 h-4 bg-rose-500 text-white text-[9px] font-bold rounded-full flex items-center justify-center">2</span> -->
            </a>

            <!-- Cart -->
            <a href="<?php echo APP_URL; ?>/user/cart.php" class="relative text-gray-600 hover:text-rose-500 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                <?php if(isset($_SESSION['cart_count']) && $_SESSION['cart_count'] > 0): ?>
                <span class="absolute -top-1 -right-1 w-4 h-4 bg-rose-500 text-white text-[9px] font-bold rounded-full flex items-center justify-center animate-bounce">
                    <?php echo $_SESSION['cart_count']; ?>
                </span>
                <?php endif; ?>
            </a>
        </div>
    </div>
</header>
<!-- Spacer for Sticky Header -->
<div class="h-16"></div>
