<?php
// templates/components/bottom-nav.php
$currentParams = $_SERVER['PHP_SELF'];

function isActive($path) {
    global $currentParams;
    return strpos($currentParams, $path) !== false ? 'text-rose-500' : 'text-gray-400';
}
?>
<!-- Bottom Nav Spacer -->
<div class="h-20"></div>

<!-- Bottom Navigation Bar -->
<nav class="fixed bottom-0 left-0 w-full bg-white border-t border-gray-100 rounded-t-3xl shadow-[0_-5px_20px_rgba(0,0,0,0.05)] z-50 px-2 py-2 safe-pb">
    <div class="flex justify-around items-center">
        
        <!-- Home -->
        <a href="<?php echo APP_URL; ?>/user/home.php" class="flex flex-col items-center p-2 transition-transform active:scale-95 <?php echo isActive('home.php'); ?>">
            <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
            <span class="text-[10px] font-medium tracking-wide">Home</span>
        </a>

        <!-- Categories -->
        <a href="<?php echo APP_URL; ?>/user/categories.php" class="flex flex-col items-center p-2 transition-transform active:scale-95 <?php echo isActive('categories.php'); ?>">
            <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path></svg>
            <span class="text-[10px] font-medium tracking-wide">Explore</span>
        </a>

        <!-- EARN (Center Highlight) -->
        <a href="<?php echo APP_URL; ?>/user/refer.php" class="flex flex-col items-center -mt-6">
            <div class="w-14 h-14 bg-rose-500 rounded-full flex items-center justify-center shadow-lg shadow-rose-200 border-4 border-[#FFF7F2]">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <span class="text-[10px] font-bold text-rose-600 mt-1">Earn</span>
        </a>

        <!-- Orders -->
        <a href="<?php echo APP_URL; ?>/user/orders.php" class="flex flex-col items-center p-2 transition-transform active:scale-95 <?php echo isActive('orders.php'); ?>">
            <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
            <span class="text-[10px] font-medium tracking-wide">Orders</span>
        </a>

        <!-- Profile -->
        <a href="<?php echo APP_URL; ?>/user/profile.php" class="flex flex-col items-center p-2 transition-transform active:scale-95 <?php echo isActive('profile.php'); ?>">
            <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
            <span class="text-[10px] font-medium tracking-wide">Profile</span>
        </a>

    </div>
</nav>
