<?php
// src/Models/User.php (Enhanced)

class User {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getProfile($userId) {
        $stmt = $this->pdo->prepare("SELECT id, full_name, email, phone, wallet_balance, is_wallet_frozen, is_active, created_at FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        return $stmt->fetch();
    }

    public function getWalletHistory($userId) {
        $stmt = $this->pdo->prepare("SELECT * FROM wallet_transactions WHERE user_id = ? ORDER BY created_at DESC");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }

    // Secure Credit/Debit
    public function creditWallet($userId, $amount, $type, $refId, $desc) {
        // 1. Check Freeze Status
        $stmt = $this->pdo->prepare("SELECT is_wallet_frozen FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        if ($stmt->fetchColumn() == 1) {
            throw new Exception("Wallet is Frozen. Transaction Denied.");
        }

        try {
            $this->pdo->beginTransaction();

            $stmt = $this->pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?");
            $stmt->execute([$amount, $userId]);

            $stmt = $this->pdo->prepare("INSERT INTO wallet_transactions (user_id, amount, type, reference_id, description, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
            $stmt->execute([$userId, $amount, $type, $refId, $desc]);

            $this->pdo->commit();
            return true;
        } catch (Exception $e) {
            $this->pdo->rollBack();
            error_log("Wallet Error: " . $e->getMessage());
            throw $e; // Re-throw to handle in UI
        }
    }

    public function toggleBlock($userId, $status) {
        $stmt = $this->pdo->prepare("UPDATE users SET is_active = ? WHERE id = ?");
        return $stmt->execute([$status, $userId]);
    }
    
    public function toggleWalletFreeze($userId, $status) {
        $stmt = $this->pdo->prepare("UPDATE users SET is_wallet_frozen = ? WHERE id = ?");
        return $stmt->execute([$status, $userId]);
    }

    public function getAllUsers() {
         $stmt = $this->pdo->query("SELECT * FROM users ORDER BY created_at DESC");
         return $stmt->fetchAll();
    }
    
    public function getBalance($userId) {
        $stmt = $this->pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        return $stmt->fetchColumn();
    }
}
