<?php
// src/Models/Support.php

class Support {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    // Create New Ticket
    public function createTicket($userId, $subject, $message, $image = null) {
        try {
            $this->pdo->beginTransaction();

            $stmt = $this->pdo->prepare("INSERT INTO support_tickets (user_id, subject, status, created_at, updated_at) VALUES (?, ?, 'open', NOW(), NOW())");
            $stmt->execute([$userId, $subject]);
            $ticketId = $this->pdo->lastInsertId();

            $this->addMessage($ticketId, $userId, $message, $image, 'user');

            $this->pdo->commit();
            return $ticketId;
        } catch (Exception $e) {
            $this->pdo->rollBack();
            throw $e;
        }
    }

    // Add Message to Ticket
    public function addMessage($ticketId, $userId, $message, $image = null, $sender = 'user') {
        $stmt = $this->pdo->prepare("INSERT INTO support_messages (ticket_id, sender, message, attachment, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([$ticketId, $sender, $message, $image]);

        // Update Ticket Timestamp
        $stmt = $this->pdo->prepare("UPDATE support_tickets SET updated_at = NOW(), status = ? WHERE id = ?");
        // If user replies, status -> open. If admin replies, status -> replied.
        $newStatus = ($sender === 'user') ? 'open' : 'replied';
        $stmt->execute([$newStatus, $ticketId]);

        return true;
    }

    // Get User Tickets
    public function getUserTickets($userId) {
        $stmt = $this->pdo->prepare("
            SELECT t.*, 
            (SELECT message FROM support_messages WHERE ticket_id = t.id ORDER BY created_at DESC LIMIT 1) as last_message
            FROM support_tickets t 
            WHERE user_id = ? 
            ORDER BY updated_at DESC
        ");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }

    // Get Single Ticket Details
    public function getTicket($ticketId, $userId) {
        $stmt = $this->pdo->prepare("SELECT * FROM support_tickets WHERE id = ? AND user_id = ?");
        $stmt->execute([$ticketId, $userId]);
        $ticket = $stmt->fetch();

        if (!$ticket) return null;

        $stmt = $this->pdo->prepare("SELECT * FROM support_messages WHERE ticket_id = ? ORDER BY created_at ASC");
        $stmt->execute([$ticketId]);
        $messages = $stmt->fetchAll();

        return ['info' => $ticket, 'messages' => $messages];
    }
}
