<?php
// src/Models/Product.php

class Product {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getCategories() {
        $stmt = $this->db->query("SELECT * FROM categories ORDER BY sort_order ASC, name ASC");
        return $stmt->fetchAll();
    }

    public function getFeatured($limit = 6) {
        // Random for now, logic can be improved
        $stmt = $this->db->prepare("SELECT p.*, c.name as category_name 
                                   FROM products p 
                                   LEFT JOIN categories c ON p.category_id = c.id 
                                   WHERE p.is_active = 1 
                                   ORDER BY RAND() LIMIT ?");
        $stmt->bindParam(1, $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function search($query, $limit = 20) {
        $search = "%$query%";
        $stmt = $this->db->prepare("SELECT p.*, c.name as category_name 
                                   FROM products p 
                                   LEFT JOIN categories c ON p.category_id = c.id 
                                   WHERE p.is_active = 1 AND (p.name LIKE ? OR p.description LIKE ?)
                                   LIMIT ?");
        $stmt->bindParam(1, $search, PDO::PARAM_STR);
        $stmt->bindParam(2, $search, PDO::PARAM_STR);
        $stmt->bindParam(3, $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getBySlug($slug) {
        $stmt = $this->db->prepare("SELECT p.*, c.name as category_name 
                                   FROM products p 
                                   LEFT JOIN categories c ON p.category_id = c.id 
                                   WHERE p.slug = ? AND p.is_active = 1");
        $stmt->execute([$slug]);
        $product = $stmt->fetch();

        if ($product) {
            // Get Variants
            $vStmt = $this->db->prepare("SELECT * FROM product_variants WHERE product_id = ?");
            $vStmt->execute([$product['id']]);
            $product['variants'] = $vStmt->fetchAll();
        }
        return $product;
    }
    
    public function getById($id) {
         $stmt = $this->db->prepare("SELECT * FROM products WHERE id = ?");
         $stmt->execute([$id]);
         return $stmt->fetch();
    }
}
