<?php
// src/Models/Category.php

class Category {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM categories ORDER BY id ASC"); // Hierarchy handled by parent_id
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM categories WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($name, $image = null, $parentId = null) {
        $stmt = $this->pdo->prepare("INSERT INTO categories (name, image, parent_id, created_at) VALUES (?, ?, ?, NOW())");
        $stmt->execute([$name, $image, $parentId]);
        return $this->pdo->lastInsertId();
    }

    public function update($id, $name, $image = null, $parentId = null) {
        $sql = "UPDATE categories SET name = ?, parent_id = ? WHERE id = ?";
        $params = [$name, $parentId, $id];

        if ($image) {
            $sql = "UPDATE categories SET name = ?, parent_id = ?, image = ? WHERE id = ?";
            $params = [$name, $parentId, $image, $id];
        }

        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute($params);
    }

    public function delete($id) {
        // Prevent delete if has products
        $check = $this->pdo->prepare("SELECT COUNT(*) FROM products WHERE category_id = ?");
        $check->execute([$id]);
        if($check->fetchColumn() > 0) throw new Exception("Cannot delete category with attached products.");

        $stmt = $this->pdo->prepare("DELETE FROM categories WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
