<?php
// src/Models/Admin/AdminSupport.php
require_once ROOT_PATH . '/src/Models/Support.php';

class AdminSupport {
    private $db;
    private $baseSupport;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
        $this->baseSupport = new Support();
    }

    public function getAllTickets() {
        $sql = "SELECT st.*, u.full_name FROM support_tickets st JOIN users u ON st.user_id = u.id ORDER BY st.updated_at DESC";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    public function getTicketDetails($id) {
        $stmt = $this->db->prepare("SELECT st.*, u.full_name FROM support_tickets st JOIN users u ON st.user_id = u.id WHERE st.id = ?");
        $stmt->execute([$id]);
        $ticket = $stmt->fetch();

        if (!$ticket) return null;

        $mStmt = $this->db->prepare("SELECT * FROM support_messages WHERE ticket_id = ? ORDER BY created_at ASC");
        $mStmt->execute([$id]);
        $ticket['messages'] = $mStmt->fetchAll();

        return $ticket;
    }

    public function reply($ticketId, $message) {
        return $this->baseSupport->reply($ticketId, null, $message, true);
    }
}
