<?php
// src/Models/Admin/AdminOrder.php

require_once ROOT_PATH . '/src/Models/Order.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

class AdminOrder {
    private $db;
    private $userOrderModel;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
        $this->userOrderModel = new Order();
        $this->auth = new AdminAuth();
    }

    public function getAllOrders($page = 1, $limit = 20, $status = 'all') {
        $offset = ($page - 1) * $limit;
        $sql = "SELECT o.*, u.full_name, u.phone FROM orders o JOIN users u ON o.user_id = u.id";
        $params = [];

        if ($status !== 'all') {
            $sql .= " WHERE o.order_status = ?";
            $params[] = $status;
        }

        $sql .= " ORDER BY o.created_at DESC LIMIT $limit OFFSET $offset";

        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }

    public function getOrderDetails($id) {
        $stmt = $this->db->prepare("SELECT o.*, u.full_name, u.email, u.phone FROM orders o JOIN users u ON o.user_id = u.id WHERE o.id = ?");
        $stmt->execute([$id]);
        $order = $stmt->fetch();

        if (!$order) return null;

        $iStmt = $this->db->prepare("SELECT * FROM order_items WHERE order_id = ?");
        $iStmt->execute([$id]);
        $order['items'] = $iStmt->fetchAll();

        return $order;
    }

    public function updateOrderStatus($adminId, $orderId, $status) {
        // Use the centralized Order model logic which handles Referral/Wallet triggers
        $this->userOrderModel->updateStatus($orderId, $status);
        
        // Log it
        $this->auth->logAction($adminId, 'Update Order Status', "Order #$orderId to $status");
        
        return true;
    }
}
