<?php
// src/Models/Admin/AdminLog.php

class AdminLog {
    private $pdo;

    public function __construct() {
        $this->pdo = Database::getInstance()->getConnection();
    }

    public function log($adminId, $action, $targetId = null, $details = null) {
        try {
            $ip = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
            $stmt = $this->pdo->prepare("INSERT INTO admin_logs (admin_id, action, target_id, details, ip_address, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
            $stmt->execute([$adminId, $action, $targetId, $details, $ip]);
        } catch (Exception $e) {
            // Do not crash app if logging fails, but try to log system error
            error_log("Admin Log Failed: " . $e->getMessage());
        }
    }
}
