<?php
// src/Models/Admin/AdminAuth.php

class AdminAuth {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function login($email, $password) {
        $stmt = $this->db->prepare("SELECT * FROM admins WHERE email = ? AND is_active = 1");
        $stmt->execute([$email]);
        $admin = $stmt->fetch();

        if ($admin && password_verify($password, $admin['password_hash'])) {
            // Update Last Login
            $up = $this->db->prepare("UPDATE admins SET last_login = NOW() WHERE id = ?");
            $up->execute([$admin['id']]);
            
            // Log
            $this->logAction($admin['id'], 'Login', 'Admin logged in');

            return $admin;
        }
        return false;
    }

    public function logAction($adminId, $action, $details = null) {
        $stmt = $this->db->prepare("INSERT INTO admin_logs (admin_id, action, details, ip_address) VALUES (?, ?, ?, ?)");
        $ip = $_SERVER['REMOTE_ADDR'] ?? null;
        $stmt->execute([$adminId, $action, $details, $ip]);
    }

    public function getDashboardStats() {
        $stats = [];
        
        // Revenue
        $s1 = $this->db->query("SELECT SUM(total_amount) FROM orders WHERE payment_status IN ('paid', 'cod_paid')");
        $stats['revenue'] = $s1->fetchColumn() ?: 0;

        // Total Orders
        $s2 = $this->db->query("SELECT COUNT(*) FROM orders");
        $stats['orders_count'] = $s2->fetchColumn();

        // Pending Orders
        $s3 = $this->db->query("SELECT COUNT(*) FROM orders WHERE order_status = 'pending'");
        $stats['pending_orders'] = $s3->fetchColumn();

        // Users
        $s4 = $this->db->query("SELECT COUNT(*) FROM users");
        $stats['users_count'] = $s4->fetchColumn();

        return $stats;
    }
}
