<?php
// src/Models/Admin.php

class Admin {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getDashboardStats() {
        $stats = [];

        // 1. Orders Today
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM orders WHERE DATE(created_at) = CURDATE()");
        $stats['orders_today'] = $stmt->fetchColumn();

        // 2. Revenue Today (Paid only)
        $stmt = $this->pdo->query("SELECT SUM(total_amount) FROM orders WHERE payment_status = 'paid' AND DATE(created_at) = CURDATE()");
        $stats['revenue_today'] = $stmt->fetchColumn() ?: 0;

        // 3. Pending Orders
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM orders WHERE order_status = 'pending'");
        $stats['pending_orders'] = $stmt->fetchColumn();

        // 4. Low Stock
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM product_variants WHERE stock_quantity < 5");
        $stats['low_stock'] = $stmt->fetchColumn();

        // 5. Open Tickets
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM support_tickets WHERE status = 'open'");
        $stats['open_tickets'] = $stmt->fetchColumn();
        
        // 6. Total Users
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM users");
        $stats['total_users'] = $stmt->fetchColumn();

        return $stats;
    }

    public function getRecentOrders($limit = 5) {
        $stmt = $this->pdo->prepare("SELECT * FROM orders ORDER BY created_at DESC LIMIT ?");
        $stmt->bindValue(1, $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
