<?php
// src/Helpers/SmsHelper.php

class SmsHelper {
    
    public static function sendOTP($mobile, $otp) {
        // Fast2SMS API Implementation
        $apiKey = SMS_API_KEY;
        $message = "Your OTP is: $otp";
        
        // Fast2SMS Quick Send API URL (Get params)
        // route=otp is specifically for OTPs
        $url = "https://www.fast2sms.com/dev/bulkV2?authorization=$apiKey&route=otp&variables_values=$otp&flash=0&numbers=$mobile";

        // Use cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Handle hosting SSL quirks
        
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err) {
            error_log("SMS Error: " . $err);
            return false;
        }

        // Check response
        $result = json_decode($response, true);
        if (isset($result['return']) && $result['return'] == true) {
            return true;
        }
        
        error_log("SMS API Fail: " . $response);
        return false;
    }
}
