<?php
// src/Helpers/ApiResponse.php

class ApiResponse {
    
    public static function send($data, $message = 'Success', $success = true, $statusCode = 200) {
        // Clear buffer
        if (ob_get_length()) ob_clean();

        header('Content-Type: application/json; charset=utf-8');
        http_response_code($statusCode);

        // Security Headers for API
        header('X-Content-Type-Options: nosniff');
        header('X-Frame-Options: DENY');

        $response = [
            'success' => $success,
            'message' => $message,
            'data' => $data,
            'timestamp' => time()
        ];

        echo json_encode($response);
        exit;
    }

    public static function success($data = [], $message = 'Success') {
        self::send($data, $message, true, 200);
    }

    public static function error($message = 'Error', $statusCode = 400, $data = []) {
        self::send($data, $message, false, $statusCode);
    }

    public static function unauthorized($message = 'Unauthorized') {
        self::send([], $message, false, 401);
    }
}
