<?php
// public_html/user/wishlist.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';

// Check Login
if (!isset($_SESSION['user_id'])) {
    redirect('/user/auth/login-signup.php');
}

// Fetch Wishlist Items
$userId = $_SESSION['user_id'];
$stmt = $pdo->prepare("
    SELECT w.*, p.name, p.slug, p.base_price, p.image 
    FROM wishlist w 
    JOIN products p ON w.product_id = p.id 
    WHERE w.user_id = ? 
    ORDER BY w.created_at DESC
");
$stmt->execute([$userId]);
$wishlist = $stmt->fetchAll();

$pageTitle = 'My Wishlist';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Wishlist | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <?php require_once ROOT_PATH . '/templates/components/header.php'; ?>

    <div class="p-4">
        <h1 class="text-2xl font-bold text-gray-900 mb-6">Wishlist (<?php echo count($wishlist); ?>)</h1>

        <?php if(empty($wishlist)): ?>
            <div class="text-center py-10">
                <p class="text-gray-400">Your wishlist is empty.</p>
                <a href="home.php" class="text-rose-500 font-bold mt-2 block">Continue Shopping</a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-2 gap-4">
                <?php foreach($wishlist as $item): ?>
                <div class="bg-white rounded-2xl p-3 shadow-sm relative">
                    <img src="<?php echo $item['image']; ?>" class="w-full aspect-square object-cover rounded-xl mb-3">
                    <h3 class="font-bold text-sm truncate"><?php echo e($item['name']); ?></h3>
                    <p class="text-rose-500 font-bold text-sm"><?php echo format_price($item['base_price']); ?></p>
                    
                    <button class="w-full mt-3 bg-gray-900 text-white py-2 rounded-lg text-xs font-bold">Move to Bag</button>
                    <a href="?remove=<?php echo $item['id']; ?>" class="absolute top-2 right-2 p-1 bg-white/50 rounded-full text-gray-500">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
