<?php
// public_html/user/wallet/wallet.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$userModel = new User($pdo);
$profile = $userModel->getProfile($_SESSION['user_id']);
$history = $userModel->getWalletHistory($_SESSION['user_id']);

$pageTitle = 'My Wallet';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Wallet | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
     <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <a href="../profile.php" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></a>
        <h1 class="font-bold text-lg">My Wallet</h1>
    </div>

    <div class="p-4">
        <!-- Balance Card -->
        <div class="bg-gradient-to-r from-gray-900 to-gray-800 rounded-2xl p-6 text-white shadow-xl mb-6 relative overflow-hidden">
            <div class="absolute right-0 top-0 w-32 h-32 bg-white/5 rounded-full -mr-10 -mt-10"></div>
            <p class="text-gray-400 text-xs font-bold uppercase tracking-widest mb-1">Available Balance</p>
            <h2 class="text-3xl font-bold"><?php echo format_price($profile['wallet_balance']); ?></h2>
            <p class="text-xs text-gray-500 mt-4">Use this balance securely during checkout.</p>
        </div>

        <!-- History -->
        <h3 class="font-bold text-gray-800 mb-4 ml-1">Transactions</h3>
        <?php if(empty($history)): ?>
            <p class="text-center text-gray-400 py-10">No transactions yet.</p>
        <?php else: ?>
            <div class="space-y-3">
                <?php foreach($history as $txn): ?>
                <div class="bg-white p-4 rounded-2xl shadow-sm flex justify-between items-center">
                    <div class="flex gap-3 items-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center <?php echo $txn['amount'] > 0 ? 'bg-green-100 text-green-500' : 'bg-red-100 text-red-500'; ?>">
                            <?php if($txn['amount'] > 0): ?>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path></svg>
                            <?php else: ?>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path></svg>
                            <?php endif; ?>
                        </div>
                        <div>
                            <p class="font-bold text-gray-800 text-sm"><?php echo e($txn['description']); ?></p>
                            <p class="text-[10px] text-gray-400"><?php echo date('d M Y, h:i A', strtotime($txn['created_at'])); ?></p>
                        </div>
                    </div>
                    <span class="font-bold <?php echo $txn['amount'] > 0 ? 'text-green-500' : 'text-gray-800'; ?>">
                        <?php echo ($txn['amount'] > 0 ? '+' : '') . format_price($txn['amount']); ?>
                    </span>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
