<?php
// public_html/user/wallet.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$userModel = new User();
$balance = $userModel->getWalletBalance($_SESSION['user_id']);
$history = $userModel->getWalletHistory($_SESSION['user_id']);

$pageTitle = 'My Wallet';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Wallet | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- Balance Card -->
    <div class="px-4 mb-6">
        <div class="bg-gradient-to-br from-gray-900 to-gray-800 rounded-2xl p-6 text-white shadow-xl">
            <p class="text-gray-400 text-sm font-medium mb-1">Total Balance</p>
            <h2 class="text-4xl font-bold"><?php echo formatPrice($balance); ?></h2>
            <div class="mt-6 flex gap-3">
                <button class="flex-1 bg-white/10 hover:bg-white/20 py-2 rounded-lg text-sm font-medium transition-colors">Add Money</button>
                <button class="flex-1 bg-white/10 hover:bg-white/20 py-2 rounded-lg text-sm font-medium transition-colors">Withdraw</button>
            </div>
        </div>
    </div>

    <!-- History -->
    <div class="px-4">
        <h3 class="text-lg font-bold text-gray-900 mb-4">Transaction History</h3>
        
        <div class="space-y-3">
            <?php foreach($history as $t): ?>
            <?php $isCredit = $t['amount'] > 0; ?>
            <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 flex justify-between items-center">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center <?php echo $isCredit ? 'bg-green-100 text-green-600' : 'bg-red-100 text-red-600'; ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <?php if($isCredit): ?>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"/>
                            <?php else: ?>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"/>
                            <?php endif; ?>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium text-gray-900 text-sm"><?php echo htmlspecialchars($t['description']); ?></p>
                        <p class="text-xs text-gray-500"><?php echo date('d M, h:i A', strtotime($t['created_at'])); ?></p>
                    </div>
                </div>
                <span class="font-bold <?php echo $isCredit ? 'text-green-600' : 'text-gray-900'; ?>">
                    <?php echo ($isCredit ? '+' : '') . formatPrice($t['amount']); ?>
                </span>
            </div>
            <?php endforeach; ?>
            
            <?php if(empty($history)): ?>
                <p class="text-center text-gray-400 text-sm py-4">No transactions yet.</p>
            <?php endif; ?>
        </div>
    </div>

    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
