<?php
// public_html/user/support/view.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$ticketId = $_GET['id'] ?? 0;
$support = new Support();
$ticket = $support->getTicketDetails($_SESSION['user_id'], $ticketId);

if (!$ticket) { echo "Ticket not found"; exit; }

// Handle Reply
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $msg = sanitize($_POST['message']);
    if ($msg) {
        $support->reply($ticketId, $_SESSION['user_id'], $msg);
        redirect("/user/support/view.php?id=$ticketId");
    }
}

$pageTitle = '#' . $ticketId;
$showBackButton = true;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Ticket #<?php echo $ticketId; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 h-screen flex flex-col">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <div class="px-4 py-2 border-b border-gray-100 bg-white">
        <h2 class="font-bold text-gray-900"><?php echo htmlspecialchars($ticket['subject']); ?></h2>
        <span class="text-xs px-2 py-0.5 rounded bg-gray-100 text-gray-600 uppercase"><?php echo $ticket['status']; ?></span>
    </div>

    <!-- Chat Area -->
    <div class="flex-1 overflow-y-auto p-4 space-y-4">
        <?php foreach($ticket['messages'] as $m): ?>
            <?php $isAdmin = $m['is_admin']; ?>
            <div class="flex <?php echo $isAdmin ? 'justify-start' : 'justify-end'; ?>">
                <div class="max-w-[80%] <?php echo $isAdmin ? 'bg-white text-gray-800' : 'bg-rose-500 text-white'; ?> p-3 rounded-2xl shadow-sm <?php echo $isAdmin ? 'rounded-tl-none' : 'rounded-tr-none'; ?>">
                    
                    <?php if($m['attachment_url']): ?>
                        <a href="<?php echo $m['attachment_url']; ?>" target="_blank" class="block mb-2 text-xs underline opacity-80">View Attachment</a>
                    <?php endif; ?>
                    
                    <p class="text-sm"><?php echo nl2br(htmlspecialchars($m['message'])); ?></p>
                    <p class="text-[10px] opacity-50 mt-1 text-right"><?php echo date('h:i A', strtotime($m['created_at'])); ?></p>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Reply Box -->
    <form method="POST" class="bg-white px-4 py-3 border-t border-gray-100 flex gap-2 pb-safe">
        <input type="text" name="message" placeholder="Type a message..." required class="flex-1 bg-gray-50 border border-gray-200 rounded-full px-4 py-2 outline-none focus:border-rose-500">
        <button type="submit" class="bg-rose-500 text-white p-2 rounded-full w-10 h-10 flex items-center justify-center shadow-lg">
            <svg class="w-5 h-5 ml-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/></svg>
        </button>
    </form>
</body>
</html>
