<?php
// public_html/user/support/index.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$support = new Support();
$tickets = $support->getUserTickets($_SESSION['user_id']);
$waConfig = $support->getWhatsAppConfig();

$pageTitle = 'Help & Support';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Support | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- WhatsApp Banner -->
    <?php if(($waConfig['whatsapp_support_enabled'] ?? '0') == '1'): ?>
    <div class="px-4 mb-4">
        <a href="https://wa.me/<?php echo $waConfig['whatsapp_number']; ?>" class="flex items-center gap-3 bg-green-50 border border-green-200 p-4 rounded-xl">
            <div class="w-10 h-10 bg-green-500 rounded-full flex items-center justify-center text-white">
                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24"><path d="M...Z" /></svg> <!-- Simplified icon -->
                <span class="font-bold text-lg">WA</span> 
            </div>
            <div>
                <h3 class="font-bold text-green-900">Chat on WhatsApp</h3>
                <p class="text-xs text-green-700">Get instant replies</p>
            </div>
            <svg class="w-5 h-5 text-green-600 ml-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
        </a>
    </div>
    <?php endif; ?>

    <!-- Tickets List -->
    <div class="px-4 space-y-3">
        <h2 class="text-lg font-bold text-gray-900">Your Tickets</h2>
        
        <?php foreach($tickets as $t): ?>
        <a href="view.php?id=<?php echo $t['id']; ?>" class="block bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="flex justify-between items-start mb-1">
                <h3 class="font-medium text-gray-900 line-clamp-1"><?php echo htmlspecialchars($t['subject']); ?></h3>
                <span class="text-xs font-bold uppercase px-2 py-1 rounded bg-gray-100 text-gray-600">
                    <?php echo $t['status']; ?>
                </span>
            </div>
            <p class="text-xs text-gray-500">Last update: <?php echo date('d M', strtotime($t['updated_at'])); ?></p>
        </a>
        <?php endforeach; ?>

        <?php if(empty($tickets)): ?>
            <p class="text-center text-gray-500 py-6">No support tickets found.</p>
        <?php endif; ?>
    </div>

    <!-- Floating Create Button -->
    <a href="create.php" class="fixed bottom-24 right-4 bg-rose-500 text-white w-14 h-14 rounded-full shadow-lg flex items-center justify-center z-40 transition-transform active:scale-95">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
    </a>

    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
