<?php
// public_html/user/support/create.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = sanitize($_POST['subject']);
    $message = sanitize($_POST['message']);
    
    // File Upload (Simplified)
    $attachment = null;
    if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'pdf'];
        $ext = strtolower(pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, $allowed)) {
            $filename = uniqid() . '.' . $ext;
            $path = PUBLIC_PATH . '/uploads/' . $filename;
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $path)) {
                $attachment = '/public_html/uploads/' . $filename;
            }
        }
    }

    $support = new Support();
    $res = $support->createTicket($_SESSION['user_id'], $subject, $message, $attachment);
    
    if (isset($res['success'])) {
        redirect('/user/support/view.php?id=' . $res['ticket_id']);
    } else {
        $error = $res['error'];
    }
}
$pageTitle = 'New Ticket';
$showBackButton = true;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>New Ticket | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>
    
    <form method="POST" enctype="multipart/form-data" class="px-4 space-y-4">
        <input type="text" name="subject" placeholder="Subject" required class="w-full px-4 py-3 bg-white border border-gray-200 rounded-xl outline-none focus:border-rose-500">
        
        <textarea name="message" rows="6" placeholder="Describe your issue..." required class="w-full px-4 py-3 bg-white border border-gray-200 rounded-xl outline-none focus:border-rose-500"></textarea>
        
        <!-- File Input -->
        <div class="relative border-2 border-dashed border-gray-300 rounded-xl p-4 text-center hover:bg-gray-50 transition-colors">
            <input type="file" name="attachment" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
            <div class="text-gray-500">
                <svg class="mx-auto h-8 w-8 text-gray-400 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/></svg>
                <span class="text-sm font-medium">Attach File (Optional)</span>
            </div>
        </div>

        <button type="submit" class="w-full bg-rose-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-rose-200">Submit Ticket</button>
    </form>
</body>
</html>
