<?php
// public_html/user/search.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Product.php';

$q = sanitize_input($_GET['q'] ?? '');
$catId = (int)($_GET['cat'] ?? 0);
$sort = $_GET['sort'] ?? 'newest';

$productModel = new Product($pdo);

// Build Query Logic (Simplified)
$sql = "SELECT p.*, c.name as category_name FROM products p 
        LEFT JOIN categories c ON p.category_id = c.id 
        WHERE p.is_active = 1";
$params = [];

if ($q) {
    $sql .= " AND (p.name LIKE ? OR p.description LIKE ?)";
    $params[] = "%$q%";
    $params[] = "%$q%";
}
if ($catId) {
    $sql .= " AND p.category_id = ?";
    $params[] = $catId;
}

// Sorting
if ($sort === 'price_low') $sql .= " ORDER BY p.price ASC";
else if ($sort === 'price_high') $sql .= " ORDER BY p.price DESC";
else $sql .= " ORDER BY p.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll();

$pageTitle = 'Search';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Search | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">

    <!-- Search Header -->
    <div class="sticky top-0 bg-white/90 backdrop-blur shadow-sm z-40 p-4">
        <form action="" method="GET" class="relative">
            <input type="text" name="q" value="<?php echo e($q); ?>" placeholder="Search for products..." 
                   class="w-full pl-10 pr-4 py-3 bg-gray-100 rounded-xl outline-none focus:ring-2 focus:ring-rose-500 transition-all font-medium">
            <button type="submit" class="absolute left-3 top-3.5 text-gray-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
            </button>
        </form>
        
        <!-- Filters (Scrollable) -->
        <div class="flex gap-2 mt-3 overflow-x-auto no-scrollbar pb-1">
            <a href="?sort=newest&q=<?php echo e($q); ?>" class="px-4 py-1.5 rounded-full text-xs font-bold border <?php echo $sort == 'newest' ? 'bg-rose-500 text-white border-rose-500' : 'bg-white text-gray-600 border-gray-200'; ?>">Newest</a>
            <a href="?sort=price_low&q=<?php echo e($q); ?>" class="px-4 py-1.5 rounded-full text-xs font-bold border <?php echo $sort == 'price_low' ? 'bg-rose-500 text-white border-rose-500' : 'bg-white text-gray-600 border-gray-200'; ?>">Price: Low to High</a>
            <a href="?sort=price_high&q=<?php echo e($q); ?>" class="px-4 py-1.5 rounded-full text-xs font-bold border <?php echo $sort == 'price_high' ? 'bg-rose-500 text-white border-rose-500' : 'bg-white text-gray-600 border-gray-200'; ?>">Price: High to Low</a>
        </div>
    </div>

    <!-- Results -->
    <div class="p-4">
        <?php if(count($results) > 0): ?>
            <div class="grid grid-cols-2 gap-4">
                <?php foreach($results as $prod): ?>
                <!-- Product Card Same as Home -->
                <a href="product-details.php?slug=<?php echo $prod['slug']; ?>" class="bg-white rounded-2xl p-3 shadow-sm border border-gray-100 group active:scale-95 transition-transform">
                    <div class="relative aspect-[3/4] rounded-xl overflow-hidden mb-3 bg-gray-100">
                        <img src="<?php echo $prod['image'] ?? '/assets/images/placeholder.png'; ?>" class="w-full h-full object-cover">
                    </div>
                    <h3 class="font-bold text-gray-800 text-sm truncate"><?php echo e($prod['name']); ?></h3>
                    <div class="flex items-center justify-between mt-1">
                        <span class="font-bold text-rose-600"><?php echo format_price($prod['base_price']); ?></span>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-20">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <h3 class="font-bold text-gray-800 mb-1">No results found</h3>
                <p class="text-xs text-gray-500">Try searching for something else</p>
            </div>
        <?php endif; ?>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
