<?php
// public_html/user/refer.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

// Fetch user code
$stmt = $pdo->prepare("SELECT referral_code FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$code = $stmt->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Refer & Earn | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24 text-center">
    
    <div class="bg-rose-500 text-white p-8 rounded-b-[3rem] mb-8">
        <h1 class="text-2xl font-bold mb-2">Refer & Earn ₹50</h1>
        <p class="text-rose-100 text-sm">Invite your friends and earn money in your wallet!</p>
    </div>

    <div class="px-6">
        <img src="https://cdn-icons-png.flaticon.com/512/3893/3893066.png" class="w-40 mx-auto mb-8 animate-bounce">
        
        <div class="bg-white p-6 rounded-2xl shadow-sm mb-6">
            <p class="text-xs text-gray-500 font-bold uppercase tracking-widest mb-2">Your Referral Code</p>
            <div class="bg-gray-100 p-4 rounded-xl flex justify-between items-center border-2 border-dashed border-gray-300">
                <span class="text-2xl font-bold text-gray-800 tracking-widest"><?php echo $code; ?></span>
                <button onclick="navigator.clipboard.writeText('<?php echo $code; ?>'); alert('Copied!');" class="text-rose-500 font-bold text-sm">COPY</button>
            </div>
        </div>

        <button onclick="if(navigator.share) navigator.share({title: 'Join <?php echo SITE_NAME; ?>', text: 'Use my code <?php echo $code; ?> to get ₹50!', url: '<?php echo APP_URL; ?>'});" class="w-full bg-green-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-green-200 active:scale-95 transition-transform flex items-center justify-center gap-2">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"></path></svg>
            Share on WhatsApp
        </button>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
