<?php
// public_html/user/profile.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$userModel = new User($pdo);
$profile = $userModel->getProfile($_SESSION['user_id']);

$pageTitle = 'Profile';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Profile | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="h-40 bg-rose-500 rounded-b-[3rem] relative mb-16">
        <div class="absolute -bottom-10 left-1/2 -translate-x-1/2">
             <div class="w-24 h-24 bg-white rounded-full p-1 shadow-lg">
                 <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png" class="w-full h-full rounded-full bg-gray-100">
             </div>
        </div>
    </div>
    
    <div class="text-center mb-8">
        <h2 class="font-bold text-xl text-gray-900"><?php echo e($profile['full_name'] ?? 'User'); ?></h2>
        <p class="text-sm text-gray-500">+91 <?php echo $profile['phone']; ?></p>
    </div>

    <div class="px-6 space-y-4">
        
        <!-- Wallet Card -->
        <a href="wallet/wallet.php" class="bg-gray-900 text-white p-5 rounded-2xl shadow-lg flex justify-between items-center active:scale-95 transition-transform">
            <div>
                <p class="text-xs text-gray-400 font-bold uppercase">Wallet Balance</p>
                <p class="text-2xl font-bold"><?php echo format_price($profile['wallet_balance']); ?></p>
            </div>
            <div class="bg-white/10 p-2 rounded-full">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
            </div>
        </a>

        <!-- Menu -->
        <div class="bg-white rounded-2xl shadow-sm overflow-hidden">
            <?php
            $menu = [
                ['Orders', 'orders/orders-list.php', 'M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z'],
                ['Wishlist', 'wishlist.php', 'M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z'],
                ['Refer & Earn', 'refer.php', 'M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z'],
                ['Support', 'support/index.php', 'M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z'],
            ];
            foreach($menu as $item): ?>
            <a href="<?php echo $item[1]; ?>" class="flex items-center gap-4 p-4 border-b border-gray-50 last:border-0 hover:bg-gray-50 transition-colors">
                 <div class="w-10 h-10 rounded-full bg-rose-50 text-rose-500 flex items-center justify-center">
                     <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?php echo $item[2]; ?>"></path></svg>
                 </div>
                 <span class="font-bold text-gray-700 flex-1"><?php echo $item[0]; ?></span>
                 <svg class="w-5 h-5 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
            </a>
            <?php endforeach; ?>
        </div>
        
        <a href="auth/logout.php" class="block w-full text-center py-4 text-red-500 font-bold bg-white rounded-2xl shadow-sm">Logout</a>
        
        <p class="text-center text-xs text-gray-400">Ver 1.0.0</p>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
