<?php
// public_html/user/product-details.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Product.php';
require_once ROOT_PATH . '/templates/components/popup-modal.php'; // Include Modal

$slug = $_GET['slug'] ?? '';
$productModel = new Product($pdo);

// Fetch Product (Using SQL direct for now as Helper method might differ)
$stmt = $pdo->prepare("SELECT * FROM products WHERE slug = ? AND is_active = 1");
$stmt->execute([$slug]);
$product = $stmt->fetch();

if (!$product) {
    redirect('/user/search.php');
}

// Fetch Variants
$vStmt = $pdo->prepare("SELECT * FROM product_variants WHERE product_id = ? AND stock_quantity > 0");
$vStmt->execute([$product['id']]);
$variants = $vStmt->fetchAll();

$pageTitle = $product['name'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo e($product['name']); ?> | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">

    <!-- Header (Back Button) -->
    <div class="absolute top-0 w-full z-10 p-4 flex justify-between">
        <button onclick="history.back()" class="w-10 h-10 bg-white/80 backdrop-blur rounded-full flex items-center justify-center shadow-sm">
            <svg class="w-5 h-5 text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
        </button>
        <div class="flex gap-2">
            <button class="w-10 h-10 bg-white/80 backdrop-blur rounded-full flex items-center justify-center shadow-sm text-rose-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path></svg>
            </button>
             <a href="cart.php" class="w-10 h-10 bg-white/80 backdrop-blur rounded-full flex items-center justify-center shadow-sm text-gray-700">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
            </a>
        </div>
    </div>

    <!-- Image Gallery -->
    <div class="w-full h-[50vh] bg-white relative">
        <img src="<?php echo $product['image'] ?? '/assets/images/placeholder.png'; ?>" class="w-full h-full object-cover">
    </div>

    <!-- Details Sheet -->
    <div class="-mt-8 rounded-t-[2.5rem] bg-white min-h-[50vh] relative z-0 p-6 shadow-[0_-10px_40px_rgba(0,0,0,0.05)]">
        
        <div class="w-12 h-1.5 bg-gray-200 rounded-full mx-auto mb-6"></div>

        <h1 class="text-2xl font-bold text-gray-900 mb-2 leading-tight"><?php echo e($product['name']); ?></h1>
        
        <div class="flex items-center gap-2 mb-6">
            <span class="text-2xl font-bold text-rose-500"><?php echo format_price($product['base_price']); ?></span>
            <span class="text-sm text-gray-400 line-through">₹<?php echo $product['base_price'] * 1.5; ?></span>
            <span class="bg-rose-100 text-rose-600 text-[10px] font-bold px-2 py-1 rounded-full">33% OFF</span>
        </div>

        <!-- Variants -->
        <?php if(count($variants) > 0): ?>
        <div class="mb-6">
            <h4 class="text-sm font-bold text-gray-900 mb-3">Select Variant</h4>
            <div class="flex gap-3 overflow-x-auto no-scrollbar pb-2">
                <?php foreach($variants as $idx => $var): ?>
                <label class="cursor-pointer">
                    <input type="radio" name="variant" value="<?php echo $var['id']; ?>" class="peer hidden" <?php echo $idx === 0 ? 'checked' : ''; ?>>
                    <div class="px-4 py-2 border border-gray-200 rounded-xl text-sm font-medium text-gray-600 peer-checked:border-rose-500 peer-checked:bg-rose-50 peer-checked:text-rose-600 transition-all">
                        <?php echo e($var['size_name'] . ' / ' . $var['color_name']); ?>
                    </div>
                </label>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Description -->
        <h4 class="text-sm font-bold text-gray-900 mb-2">Description</h4>
        <p class="text-sm text-gray-500 leading-relaxed mb-8">
            <?php echo nl2br(e($product['description'])); ?>
        </p>

    </div>

    <!-- Bottom Bar -->
    <div class="fixed bottom-0 left-0 w-full bg-white border-t border-gray-100 p-4 safe-pb z-50 flex items-center gap-4">
        <button class="w-12 h-12 flex items-center justify-center border border-gray-200 rounded-xl text-gray-400">
             <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path></svg>
        </button>
        <button id="addToCartBtn" class="flex-1 bg-gray-900 text-white font-bold py-3.5 rounded-xl shadow-lg active:scale-95 transition-transform">
            Add to Cart
        </button>
        <button class="flex-1 bg-rose-500 text-white font-bold py-3.5 rounded-xl shadow-lg shadow-rose-200 active:scale-95 transition-transform">
            Buy Now
        </button>
    </div>

    <script>
        document.getElementById('addToCartBtn').addEventListener('click', async () => {
             // Logic to Add to Cart via API
             // Assuming Cart API exists or will be created
             // Using Popup.show() from previous step
             
             // Get Selected Variant
             const selected = document.querySelector('input[name="variant"]:checked');
             const variantId = selected ? selected.value : null;

            if (!variantId && <?php echo count($variants) > 0 ? 'true' : 'false'; ?>) {
                Popup.show('error', 'Select Option', 'Please select a size/color.');
                return;
            }
             
             // Simulate Success for now until Cart API is linked in next logical step
             Popup.show('success', 'Added to Cart', 'Product added to your bag!', () => {
                 window.location.href = 'cart.php';
             });
        });
    </script>
</body>
</html>
