<?php
// public_html/user/payment.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();

    $userId = $_SESSION['user_id'];
    $addressId = $_POST['address_id'] ?? 0;
    $paymentMethod = $_POST['payment_method'] ?? 'cod';
    $useWallet = isset($_POST['use_wallet']) ? true : false;

    // Logic:
    // If Online Payment -> Redirect to Gateway (Simulate for now)
    // If COD / Wallet Full -> Create Order Immediately

    if ($paymentMethod === 'online') {
        // Here we would create a Razorpay Order ID etc.
        // For simulation, we assume success immediately.
    }

    $orderModel = new Order($pdo);
    try {
        $orderNumber = $orderModel->createOrder($userId, $addressId, $paymentMethod, $useWallet);
        
        // Success
        redirect("/user/order-success.php?id=$orderNumber");

    } catch (Exception $e) {
        // Error
        // In Prod: Log error and show friendly message
        die("Order Failed: " . $e->getMessage());
    }
} else {
    redirect('cart.php');
}
