<?php
// public_html/user/orders/orders-list.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$orderModel = new Order($pdo);
$orders = $orderModel->getUserOrders($_SESSION['user_id']);

$pageTitle = 'My Orders';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>My Orders | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <a href="../profile.php" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></a>
        <h1 class="font-bold text-lg">My Orders</h1>
    </div>

    <div class="p-4 space-y-4">
        <?php if(empty($orders)): ?>
            <div class="text-center py-20">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4 text-gray-400">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                </div>
                <h3 class="font-bold text-gray-800">No Orders Yet</h3>
                <a href="../home.php" class="text-rose-500 font-bold text-sm mt-2 block">Start Shopping</a>
            </div>
        <?php else: ?>
            <?php foreach($orders as $order): ?>
                <?php
                    // Status Badge Logic
                    $statusColor = 'bg-gray-100 text-gray-600';
                    if($order['order_status'] == 'delivered') $statusColor = 'bg-green-100 text-green-600';
                    if($order['order_status'] == 'cancelled') $statusColor = 'bg-red-100 text-red-600';
                    if($order['order_status'] == 'shipped') $statusColor = 'bg-blue-100 text-blue-600';
                ?>
                <div class="bg-white p-4 rounded-2xl shadow-sm border border-gray-50 active:scale-95 transition-transform">
                    <div class="flex justify-between items-start mb-2">
                        <div>
                            <span class="text-xs font-bold text-gray-400">Order #<?php echo e($order['order_number']); ?></span>
                            <h3 class="font-bold text-gray-800"><?php echo format_price($order['total_amount']); ?></h3>
                        </div>
                        <span class="px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-wide <?php echo $statusColor; ?>">
                            <?php echo e($order['order_status']); ?>
                        </span>
                    </div>
                    <p class="text-xs text-gray-400 mb-4"><?php echo date('d M Y, h:i A', strtotime($order['created_at'])); ?></p>
                    
                    <a href="order-tracking.php?id=<?php echo $order['order_number']; ?>" class="block w-full text-center py-2 rounded-lg border border-gray-200 text-sm font-bold text-gray-600 hover:bg-gray-50 transition-colors">
                        View Details & Track
                    </a>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
