<?php
// public_html/user/orders/order-tracking.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$orderId = $_GET['id'] ?? '';
$orderModel = new Order($pdo);
$details = $orderModel->getOrderDetails($orderId, $_SESSION['user_id']);

if (!$details) {
    redirect('orders-list.php');
}

$order = $details['info'];
$items = $details['items'];
$timeline = $details['timeline'];

$pageTitle = 'Track Order';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Track Order | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <button onclick="history.back()" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></button>
        <div class="flex-1">
            <h1 class="font-bold text-lg">Order Details</h1>
            <span class="text-xs text-gray-500"><?php echo $order['order_number']; ?></span>
        </div>
        <a href="order-invoice.php?id=<?php echo $order['id']; ?>" class="text-rose-500 text-xs font-bold bg-rose-50 px-3 py-1 rounded-full">Invoice</a>
    </div>

    <div class="p-4 space-y-6">
        
        <!-- Timeline -->
        <div class="bg-white p-6 rounded-2xl shadow-sm">
            <h2 class="font-bold text-gray-800 mb-4">Tracking</h2>
            <div class="relative pl-4 border-l-2 border-gray-100 space-y-8">
                <?php foreach($timeline as $event): ?>
                <div class="relative">
                    <div class="absolute -left-[21px] top-0 w-3 h-3 rounded-full bg-rose-500 shadow-[0_0_0_4px_rgba(244,63,94,0.2)]"></div>
                    <div class="flex flex-col">
                        <span class="font-bold text-sm text-gray-800 capitalize"><?php echo $event['status']; ?></span>
                        <span class="text-xs text-gray-400"><?php echo date('d M, h:i A', strtotime($event['created_at'])); ?></span>
                        <span class="text-xs text-gray-500 mt-1"><?php echo $event['description']; ?></span>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Items -->
        <div class="bg-white p-4 rounded-2xl shadow-sm">
            <h2 class="font-bold text-gray-800 mb-4">Items (<?php echo count($items); ?>)</h2>
            <?php foreach($items as $item): ?>
            <div class="flex gap-3 mb-4 last:mb-0">
                <div class="w-14 h-14 bg-gray-100 rounded-lg"></div> <!-- Placeholder Img -->
                <div class="flex-1">
                     <h3 class="text-sm font-bold text-gray-800"><?php echo e($item['product_name_snapshot']); ?></h3>
                     <p class="text-xs text-gray-500">Qty: <?php echo $item['quantity']; ?></p>
                </div>
                <span class="text-sm font-bold text-gray-800"><?php echo format_price($item['price_at_purchase']); ?></span>
            </div>
            <?php endforeach; ?>
            <div class="border-t border-gray-100 mt-3 pt-3 flex justify-between">
                <span class="font-bold text-gray-600">Total Amount</span>
                <span class="font-bold text-gray-900"><?php echo format_price($order['total_amount']); ?></span>
            </div>
        </div>

        <!-- Address -->
        <div class="bg-white p-4 rounded-2xl shadow-sm">
            <h2 class="font-bold text-gray-800 mb-2">Delivery Address</h2>
            <?php 
                $addr = json_decode($order['shipping_address_json'], true); 
                // Fallback if decode fails or simple string
                $addrStr = is_array($addr) ? implode(', ', array_filter($addr)) : "Address info unavailable"; 
            ?>
            <p class="text-sm text-gray-600 leading-relaxed"><?php echo e($addrStr); ?></p>
        </div>

        <!-- Cancel Action -->
        <?php if(in_array($order['order_status'], ['pending', 'confirmed', 'packed'])): ?>
        <button id="cancelBtn" class="w-full py-4 text-red-500 font-bold bg-white rounded-2xl shadow-sm border border-red-100">
            Cancel Order
        </button>
        <?php endif; ?>

        <!-- Return Action (Only if Delivered) -->
        <?php if($order['order_status'] === 'delivered'): ?>
         <a href="../returns/return-refund.php?order_id=<?php echo $order['id']; ?>" class="block w-full text-center py-4 text-gray-600 font-bold bg-white rounded-2xl shadow-sm border border-gray-200">
            Return / Exchange
        </a>
        <?php endif; ?>

    </div>

    <!-- Hidden Form for Cancellation -->
    <form id="cancelForm" action="../../api/order_action.php" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="action" value="cancel_order">
        <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
    </form>

    <?php require_once ROOT_PATH . '/templates/components/popup-modal.php'; ?>
    <script>
        document.getElementById('cancelBtn')?.addEventListener('click', () => {
            Popup.show('confirm', 'Cancel Order?', 'Are you sure you want to cancel this order? If you paid online, the amount will be refunded to your wallet.', () => {
                // Submit Form via Fetch or Direct
                // For simplicity, we can use the form post if not using full AJAX suite yet.
                // But let's follow the User Request for "order-cancel.php" or API. The user asked for `order-cancel.php`.
                // I'll redirect to that page instead.
                window.location.href = 'order-cancel.php?id=<?php echo $order['id']; ?>';
            });
        });
    </script>
</body>
</html>
