<?php
// public_html/user/orders/order-invoice.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) die('Login Required');

$orderId = $_GET['id'] ?? '';
$orderModel = new Order($pdo);
$details = $orderModel->getOrderDetails($orderId, $_SESSION['user_id']);

if (!$details) die('Order Not Found');
$order = $details['info'];
$items = $details['items'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #<?php echo $order['order_number']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            body { background: white; }
            .no-print { display: none; }
        }
    </style>
</head>
<body class="bg-gray-100 p-6">
    
    <div class="max-w-2xl mx-auto bg-white p-8 shadow-sm rounded-none print:shadow-none">
        
        <!-- Header -->
        <div class="flex justify-between items-start mb-8">
            <div>
                <h1 class="font-bold text-2xl text-gray-900"><?php echo SITE_NAME; ?></h1>
                <p class="text-sm text-gray-500">Invoice #<?php echo $order['order_number']; ?></p>
                <p class="text-sm text-gray-500"><?php echo date('d M Y', strtotime($order['created_at'])); ?></p>
            </div>
            <div class="text-right">
                <p class="font-bold text-green-600 uppercase border-2 border-green-600 px-2 py-1 inline-block"><?php echo $order['payment_status']; ?></p>
            </div>
        </div>

        <!-- Bill To -->
        <div class="mb-8 border-b border-gray-100 pb-8">
            <h3 class="font-bold text-gray-800 text-sm uppercase tracking-wide mb-2">Bill To:</h3>
            <?php 
                $addr = json_decode($order['shipping_address_json'], true); 
                if($addr) {
                    echo "<p class='text-gray-600'>{$addr['name']}<br>{$addr['address']}<br>{$addr['city']} - {$addr['pincode']}</p>";
                }
            ?>
        </div>

        <!-- Items -->
        <table class="w-full mb-8">
            <thead>
                <tr class="border-b-2 border-gray-900 text-left">
                    <th class="py-2 text-sm font-bold text-gray-800">Item</th>
                    <th class="py-2 text-sm font-bold text-gray-800 text-center">Qty</th>
                    <th class="py-2 text-sm font-bold text-gray-800 text-right">Amnt</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($items as $item): ?>
                <tr class="border-b border-gray-100">
                    <td class="py-3 text-sm text-gray-600"><?php echo e($item['product_name_snapshot']); ?></td>
                    <td class="py-3 text-sm text-gray-600 text-center"><?php echo $item['quantity']; ?></td>
                    <td class="py-3 text-sm text-gray-900 font-bold text-right"><?php echo format_price($item['price_at_purchase']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Totals -->
        <div class="flex justify-end">
            <div class="w-1/2">
                <div class="flex justify-between py-1 border-b border-gray-100">
                    <span class="text-sm text-gray-500">Total</span>
                    <span class="font-bold text-gray-900"><?php echo format_price($order['total_amount']); ?></span>
                </div>
            </div>
        </div>

        <div class="mt-8 text-center no-print">
            <button onclick="window.print()" class="bg-gray-900 text-white px-6 py-2 rounded-full font-bold shadow-lg">Print Invoice</button>
        </div>

    </div>

</body>
</html>
