<?php
// public_html/user/orders/order-cancel.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$orderId = $_GET['id'] ?? null;
if (!$orderId) redirect('orders-list.php');

$orderModel = new Order($pdo);
$details = $orderModel->getOrderDetails($orderId, $_SESSION['user_id']);

if (!$details) redirect('orders-list.php');
$order = $details['info'];

// Handle Post
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();
    $reason = $_POST['reason'] ?? 'User Request';
    
    try {
        $orderModel->cancelOrder($order['id'], $_SESSION['user_id'], $reason);
        // Success
        header("Location: order-tracking.php?id=" . $order['order_number']);
        exit;
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cancel Order</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 flex flex-col items-center justify-center h-screen p-6">
    <div class="bg-white p-8 rounded-3xl w-full max-w-sm shadow-xl text-center">
        <h1 class="text-xl font-bold text-gray-900 mb-4">Cancel Order</h1>
        <p class="text-gray-500 mb-6">Are you sure you want to cancel Order #<?php echo $order['order_number']; ?>?</p>
        
        <?php if(isset($error)): ?>
            <p class="text-red-500 font-bold mb-4 bg-red-50 p-2 rounded"><?php echo $error; ?></p>
        <?php endif; ?>

        <form method="POST" class="space-y-4">
            <?php echo csrf_field(); ?>
            <select name="reason" class="w-full p-3 bg-gray-100 rounded-xl outline-none">
                <option value="Changed Mind">Changed Mind</option>
                <option value="Found Cheaper">Found Cheaper</option>
                <option value="Delayed Delivery">Delayed Delivery</option>
                <option value="Other">Other</option>
            </select>
            
            <button type="submit" class="w-full bg-red-500 text-white font-bold py-3 rounded-xl shadow-lg shadow-red-200">Yes, Cancel Order</button>
            <a href="order-tracking.php?id=<?php echo $order['order_number']; ?>" class="block text-gray-500 py-3 font-bold">No, Go Back</a>
        </form>
    </div>
</body>
</html>
