<?php
// public_html/user/orders.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$orderModel = new Order();
$orders = $orderModel->getUserOrders($_SESSION['user_id']);
$pageTitle = 'My Orders';

function getStatusColor($status) {
    return match($status) {
        'pending' => 'bg-yellow-100 text-yellow-800',
        'processing' => 'bg-blue-100 text-blue-800',
        'shipped' => 'bg-indigo-100 text-indigo-800',
        'delivered' => 'bg-green-100 text-green-800',
        'cancelled' => 'bg-red-100 text-red-800',
        default => 'bg-gray-100 text-gray-800'
    };
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>My Orders | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <div class="px-4 py-4 space-y-4">
        <?php if(empty($orders)): ?>
            <div class="text-center py-10">
                <p class="text-gray-500">No orders yet.</p>
                <a href="/public_html/home.php" class="text-rose-500 font-medium">Start Shopping</a>
            </div>
        <?php endif; ?>

        <?php foreach($orders as $o): ?>
        <a href="order-track.php?id=<?php echo $o['id']; ?>" class="block bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md transition-shadow">
            <div class="flex justify-between items-start mb-2">
                <div>
                    <h3 class="font-bold text-gray-900"><?php echo $o['order_number']; ?></h3>
                    <p class="text-xs text-gray-500"><?php echo date('d M Y, h:i A', strtotime($o['created_at'])); ?></p>
                </div>
                <span class="px-2 py-1 rounded-full text-xs font-bold uppercase <?php echo getStatusColor($o['order_status']); ?>">
                    <?php echo $o['order_status']; ?>
                </span>
            </div>
            <div class="flex justify-between items-center mt-3 pt-3 border-t border-gray-50">
                <span class="text-sm text-gray-600">Total Amount</span>
                <span class="font-bold text-gray-900"><?php echo formatPrice($o['total_amount']); ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>

    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
