<?php
// public_html/user/order-track.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$orderId = $_GET['id'] ?? 0;
$orderModel = new Order();
$order = $orderModel->getOrderDetails($_SESSION['user_id'], $orderId);

if (!$order) {
    echo "Order not found"; exit; // 404
}

$pageTitle = 'Order Details';
$showBackButton = true;

// Timeline Logic
$statusOrder = ['pending', 'processing', 'shipped', 'delivered'];
$currentStatusIdx = array_search($order['order_status'], $statusOrder);
$isCancelled = $order['order_status'] === 'cancelled';

function isStepActive($step, $current, $isCancelled) {
    if ($isCancelled) return false;
    global $statusOrder;
    $stepIdx = array_search($step, $statusOrder);
    $currIdx = array_search($current, $statusOrder);
    return $stepIdx <= $currIdx;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Track Order | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- Status Timeline -->
    <div class="bg-white p-6 mb-4 shadow-sm">
        <h2 class="text-lg font-bold text-gray-900 mb-6">Order Status</h2>
        
        <?php if($isCancelled): ?>
            <div class="bg-red-50 text-red-700 p-4 rounded-xl text-center font-bold">
                Order Cancelled
            </div>
        <?php else: ?>
            <div class="relative pl-4 border-l-2 border-gray-100 space-y-8">
                <?php foreach($statusOrder as $step): ?>
                <div class="relative">
                    <!-- Dot -->
                    <div class="absolute -left-[21px] top-1 w-3 h-3 rounded-full <?php echo isStepActive($step, $order['order_status'], false) ? 'bg-green-500 ring-4 ring-green-100' : 'bg-gray-300'; ?>"></div>
                    <h3 class="font-medium text-gray-900 capitalize"><?php echo $step; ?></h3>
                    <?php if($order['order_status'] == $step): ?>
                        <p class="text-xs text-green-600">Current Status</p>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Items -->
    <div class="bg-white p-4 mb-4 shadow-sm border-t border-b border-gray-100">
        <h3 class="font-bold text-gray-900 mb-4">Items</h3>
        <div class="space-y-4">
            <?php foreach($order['items'] as $item): ?>
            <div class="flex justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-900"><?php echo $item['product_name_snapshot']; ?></p>
                    <p class="text-xs text-gray-500">Qty: <?php echo $item['quantity']; ?></p>
                </div>
                <p class="font-medium text-gray-900"><?php echo formatPrice($item['price_at_purchase']); ?></p>
            </div>
            <?php endforeach; ?>
            <div class="border-t border-gray-100 pt-3 flex justify-between font-bold">
                <span>Total</span>
                <span><?php echo formatPrice($order['total_amount']); ?></span>
            </div>
        </div>
    </div>

    <!-- Actions -->
    <?php if(in_array($order['order_status'], ['pending', 'processing']) && !$isCancelled): ?>
    <div class="px-4">
        <button onclick="cancelOrder()" class="w-full bg-white border border-red-200 text-red-600 font-bold py-3 rounded-xl">
            Cancel Order
        </button>
    </div>
    <?php endif; ?>

    <script>
        async function cancelOrder() {
            if(!confirm("Are you sure you want to cancel this order? Refund will be credited to your wallet (if prepaid).")) return;
            
            const fd = new FormData();
            fd.append('action', 'cancel');
            fd.append('order_id', <?php echo $orderId; ?>);
            
            try {
                const res = await fetch('/public_html/api/order_action.php', { method: 'POST', body: fd, headers: {'X-Requested-With': 'XMLHttpRequest'} });
                const data = await res.json();
                if(data.success) window.location.reload();
                else alert(data.error);
            } catch(e) { alert('Error'); }
        }
    </script>

</body>
</html>
