<?php
// public_html/user/home.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php'; // Bootstrap
require_once ROOT_PATH . '/src/Models/Product.php';

$productModel = new Product($pdo);

// Fetch Data (simulated for now, normally strictly separated via controller, but this is simple PHP)
// In a real app we might use an API call or Model methods directly.
$featuredProducts = $productModel->getFeatured(6); 
$recentProducts = $productModel->getRecent(6);
$categories = $pdo->query("SELECT * FROM categories WHERE parent_id IS NULL LIMIT 8")->fetchAll();

$pageTitle = 'Home';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo APP_URL; ?>/assets/css/style.css"> <!-- Assuming style.css exists or inline -->
</head>
<body class="bg-[#FFF7F2] pb-24">

    <!-- Header -->
    <?php require_once ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- Banner Slider -->
    <div class="mt-2 px-4">
        <div class="rounded-2xl overflow-hidden shadow-lg relative h-48 bg-rose-200 skeleton-loader" id="bannerLoader">
             <!-- Skeleton -->
        </div>
        <div class="rounded-2xl overflow-hidden shadow-lg relative h-48 hidden real-content" id="bannerContent">
             <img src="https://images.unsplash.com/photo-1483985988355-763728e1935b?auto=format&fit=crop&w=800&q=80" class="w-full h-full object-cover">
             <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
                 <div class="text-white">
                     <h2 class="font-bold text-xl">New Collection</h2>
                     <button class="bg-white text-black px-4 py-1 rounded-full text-xs font-bold mt-2">Shop Now</button>
                 </div>
             </div>
        </div>
    </div>

    <!-- Categories (Instagram Style) -->
    <div class="mt-6">
        <div class="flex gap-4 overflow-x-auto px-4 no-scrollbar pb-2">
            <?php foreach($categories as $cat): ?>
            <a href="search.php?cat=<?php echo $cat['id']; ?>" class="flex flex-col items-center flex-shrink-0">
                <div class="w-16 h-16 rounded-full p-1 bg-gradient-to-tr from-rose-400 to-orange-300">
                    <div class="w-full h-full rounded-full bg-white p-0.5 overflow-hidden">
                        <!-- Placeholder Icon/Image -->
                         <img src="<?php echo $cat['image'] ?? 'https://via.placeholder.com/60'; ?>" class="w-full h-full object-cover rounded-full">
                    </div>
                </div>
                <span class="text-[10px] mt-1 font-medium text-gray-700 truncate w-16 text-center"><?php echo e($cat['name']); ?></span>
            </a>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Featured Section -->
    <div class="mt-8 px-4">
        <div class="flex justify-between items-center mb-4">
            <h2 class="font-bold text-lg text-gray-800">Featured</h2>
            <a href="search.php?sort=featured" class="text-xs text-rose-500 font-bold">See All</a>
        </div>

        <div class="grid grid-cols-2 gap-4" id="featuredGrid">
            <!-- Products -->
            <?php foreach($featuredProducts as $prod): ?>
            <a href="product-details.php?slug=<?php echo $prod['slug']; ?>" class="bg-white rounded-2xl p-3 shadow-sm border border-gray-100 group active:scale-95 transition-transform">
                <div class="relative aspect-[3/4] rounded-xl overflow-hidden mb-3 bg-gray-100">
                    <img src="<?php echo $prod['image'] ?? '/assets/images/placeholder.png'; ?>" class="w-full h-full object-cover" loading="lazy">
                    <button class="absolute top-2 right-2 p-1.5 bg-white/80 rounded-full text-rose-500 shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path></svg>
                    </button>
                </div>
                <h3 class="font-bold text-gray-800 text-sm truncate"><?php echo e($prod['name']); ?></h3>
                <p class="text-xs text-gray-500 truncate mb-2"><?php echo e($prod['category_name'] ?? 'General'); ?></p>
                <div class="flex items-center justify-between">
                    <span class="font-bold text-rose-600"><?php echo format_price($prod['price']); ?></span>
                    <div class="w-6 h-6 rounded-full bg-rose-50 text-rose-500 flex items-center justify-center">
                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
    
    <!-- Skeleton Script Activation -->
    <script src="<?php echo APP_URL; ?>/assets/js/skeleton.js"></script>
    <script>
        // Simulate loading for Banner
        setTimeout(() => {
            Skeleton.toggle('bannerLoader', false); // Hide Skeleton
            document.getElementById('bannerLoader').classList.add('hidden');
            document.getElementById('bannerContent').classList.remove('hidden');
        }, 1000);
    </script>
    
    <!-- Bottom Nav -->
    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
