<?php
// public_html/user/earning/refer-earn.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Referral.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$userId = $_SESSION['user_id'];
$userModel = new User($pdo);
$profile = $userModel->getProfile($userId);
$refCode = $pdo->query("SELECT referral_code FROM users WHERE id = $userId")->fetchColumn();

$refModel = new Referral($pdo);
$stats = $refModel->getStats($userId);
$history = $refModel->getHistory($userId);

$shareUrl = APP_URL . "/user/auth/login-signup.php?ref=" . $refCode;
$qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($shareUrl);

$pageTitle = 'Refer & Earn';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Earn Money | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <a href="../profile.php" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></a>
        <h1 class="font-bold text-lg">Refer & Earn</h1>
    </div>

    <!-- Hero Card -->
    <div class="m-4 bg-gradient-to-br from-rose-500 to-pink-600 rounded-3xl p-6 text-white shadow-xl text-center relative overflow-hidden">
        <div class="absolute -top-10 -right-10 w-40 h-40 bg-white/10 rounded-full blur-2xl"></div>
        <h2 class="text-2xl font-bold mb-1">Invite Friends</h2>
        <p class="text-rose-100 text-sm mb-6">Earn ₹50 for every friend who places their first order!</p>
        
        <div class="bg-white/20 backdrop-blur-md rounded-xl p-4 flex items-center justify-between border border-white/30">
            <div class="text-left">
                <span class="block text-xs text-rose-100 uppercase font-bold tracking-wider">Your Code</span>
                <span class="text-2xl font-bold tracking-widest font-mono"><?php echo $refCode; ?></span>
            </div>
            <button onclick="navigator.clipboard.writeText('<?php echo $refCode; ?>'); this.innerText='COPIED';" class="bg-white text-rose-600 px-4 py-2 rounded-lg font-bold text-xs shadow-sm active:scale-95 transition-transform">
                COPY
            </button>
        </div>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-3 gap-3 px-4 mb-6">
        <div class="bg-white p-3 rounded-2xl shadow-sm text-center">
            <p class="text-gray-400 text-[10px] font-bold uppercase">Invited</p>
            <p class="text-xl font-bold text-gray-800"><?php echo $stats['total_invites']; ?></p>
        </div>
        <div class="bg-white p-3 rounded-2xl shadow-sm text-center">
            <p class="text-gray-400 text-[10px] font-bold uppercase">Converted</p>
            <p class="text-xl font-bold text-green-500"><?php echo $stats['successful']; ?></p>
        </div>
        <div class="bg-white p-3 rounded-2xl shadow-sm text-center">
             <p class="text-gray-400 text-[10px] font-bold uppercase">Earned</p>
             <p class="text-xl font-bold text-rose-500">₹<?php echo number_format($stats['earned']); ?></p>
        </div>
    </div>

    <!-- QR & Actions -->
    <div class="px-4 mb-8">
        <div class="bg-white p-6 rounded-2xl shadow-sm flex flex-col items-center">
            <h3 class="font-bold text-gray-800 mb-4">Share Code</h3>
            <img src="<?php echo $qrUrl; ?>" class="w-32 h-32 rounded-xl border border-gray-100 mb-6">
            
            <button onclick="if(navigator.share) navigator.share({title:'Join <?php echo SITE_NAME; ?>', text:'Use <?php echo $refCode; ?> to get discount!', url:'<?php echo $shareUrl; ?>'})" class="w-full bg-gray-900 text-white font-bold py-3 rounded-xl shadow-lg active:scale-95 transition-transform flex justify-center items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"></path></svg>
                Share Link
            </button>
        </div>
    </div>

    <!-- History -->
    <div class="px-4">
        <h3 class="font-bold text-gray-800 mb-3 ml-1">Referral History</h3>
        <?php if(empty($history)): ?>
            <p class="text-center text-gray-400 py-4 text-sm">No invites yet.</p>
        <?php else: ?>
            <div class="space-y-3">
                <?php foreach($history as $row): ?>
                <div class="bg-white p-4 rounded-xl shadow-sm flex justify-between items-center">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center font-bold text-gray-500">
                            <?php echo strtoupper(substr($row['full_name'] ?? 'U', 0, 1)); ?>
                        </div>
                        <div>
                            <p class="font-bold text-sm text-gray-800"><?php echo e($row['full_name'] ?? 'Friend'); ?></p>
                            <p class="text-[10px] text-gray-400">Joined <?php echo date('d M Y', strtotime($row['created_at'])); ?></p>
                        </div>
                    </div>
                    <?php if($row['orders_count'] > 0): ?>
                        <span class="text-green-500 text-xs font-bold bg-green-50 px-2 py-1 rounded">Ordered</span>
                    <?php else: ?>
                        <span class="text-orange-500 text-xs font-bold bg-orange-50 px-2 py-1 rounded">Pending</span>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

</body>
</html>
