<?php
// public_html/user/checkout.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Cart.php';
require_once ROOT_PATH . '/src/Models/User.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$userId = $_SESSION['user_id'];
$cartModel = new Cart();
$cart = $cartModel->get($userId);
if ($cart['count'] == 0) redirect('cart.php');

$userModel = new User($pdo);
$balance = $userModel->getBalance($userId);

$pageTitle = 'Checkout';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Checkout | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-32">
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <button onclick="history.back()" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></button>
        <h1 class="font-bold text-lg">Checkout</h1>
    </div>

    <form action="payment.php" method="POST" class="p-4 space-y-6">
        <?php echo csrf_field(); ?>
        
        <!-- Address -->
        <section>
            <div class="flex justify-between items-center mb-3">
                <h2 class="font-bold text-gray-800">Delivery Address</h2>
                <button type="button" class="text-rose-500 text-xs font-bold">+ Add New</button>
            </div>
            <label class="block bg-white p-4 rounded-2xl shadow-sm border-2 border-rose-500 relative cursor-pointer">
                <input type="radio" name="address_id" value="1" checked class="absolute top-4 right-4 accent-rose-500 w-5 h-5">
                <h3 class="font-bold text-gray-900">User's Address</h3>
                <p class="text-sm text-gray-500 mt-1 leading-relaxed">
                    123, Fashion Street, Near Central Mall, <br>
                    Mumbai, Maharashtra - 400001
                </p>
            </label>
        </section>

        <!-- Wallet Option -->
        <?php if($balance > 0): ?>
        <section>
            <label class="flex items-center justify-between bg-white p-4 rounded-2xl shadow-sm border mb-4">
                <div class="flex items-center gap-3">
                    <div class="bg-green-100 p-2 rounded-lg text-green-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg>
                    </div>
                    <div>
                        <span class="font-bold text-gray-900 block">Use Wallet Balance</span>
                        <span class="text-xs text-gray-500">Available: <?php echo format_price($balance); ?></span>
                    </div>
                </div>
                <input type="checkbox" name="use_wallet" value="1" class="w-6 h-6 accent-green-500">
            </label>
        </section>
        <?php endif; ?>

        <!-- Payment Mode -->
        <section>
            <h2 class="font-bold text-gray-800 mb-3">Payment Method</h2>
            <div class="bg-white rounded-2xl p-2 shadow-sm">
                <label class="flex items-center gap-4 p-4 border-b border-gray-50 cursor-pointer">
                    <input type="radio" name="payment_method" value="cod" class="accent-rose-500 w-5 h-5" checked>
                    <div class="flex-1">
                        <span class="font-bold text-gray-800 block">Cash on Delivery</span>
                    </div>
                </label>
                <label class="flex items-center gap-4 p-4 cursor-pointer">
                    <input type="radio" name="payment_method" value="online" class="accent-rose-500 w-5 h-5">
                    <div class="flex-1">
                        <span class="font-bold text-gray-800 block">UPI / Card / NetBanking</span>
                        <span class="text-xs text-green-500 font-bold">Extra 5% OFF</span>
                    </div>
                </label>
            </div>
        </section>

        <!-- Bill Details -->
        <div class="bg-gray-50 p-4 rounded-xl text-sm space-y-2">
            <div class="flex justify-between"><span>Subtotal</span> <span><?php echo format_price($cart['total']); ?></span></div>
            <div class="flex justify-between font-bold text-lg pt-2 border-t"><span>Total</span> <span><?php echo format_price($cart['total']); ?></span></div>
        </div>

        <!-- Submit -->
        <div class="fixed bottom-0 left-0 w-full bg-white border-t border-gray-100 p-4 safe-pb z-50">
            <button type="submit" class="block w-full bg-gray-900 text-white text-center font-bold py-4 rounded-xl shadow-lg active:scale-95 transition-transform">
                Place Order
            </button>
        </div>
    </form>
</body>
</html>
