<?php
// public_html/user/cart.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';

// In a full implementation, we sync session cart with DB if logged in.
// For now, fetching dummy or DB items if table populated, or showing empty state.

$cartItems = []; // Placeholder. In next API step we implement Cart Logic. 
// Assuming $cartItems is fetched from DB join `carts` + `product_variants`.
$total = 0;

$pageTitle = 'My Bag';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Cart | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-32">
    <!-- Simple Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <button onclick="history.back()" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></button>
        <h1 class="font-bold text-lg">Shopping Bag</h1>
    </div>

    <div class="p-4">
        <?php if(empty($cartItems)): ?>
            <div class="flex flex-col items-center justify-center py-20 text-center">
                <div class="w-24 h-24 bg-rose-100 rounded-full flex items-center justify-center mb-6 text-rose-500">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                </div>
                <h2 class="text-xl font-bold text-gray-900 mb-2">Your bag is empty</h2>
                <p class="text-gray-500 text-sm mb-8">Looks like you haven't added anything yet.</p>
                <a href="home.php" class="bg-rose-500 text-white font-bold py-3 px-8 rounded-xl shadow-lg shadow-rose-200">Start Shopping</a>
            </div>
        <?php else: ?>
            <div class="space-y-4">
                <!-- Cart Item Loop -->
                <?php foreach($cartItems as $item): ?>
                <div class="bg-white p-3 rounded-2xl flex gap-3 shadow-sm">
                    <img src="<?php echo $item['image']; ?>" class="w-20 h-24 object-cover rounded-xl bg-gray-50">
                    <div class="flex-1 flex flex-col justify-between py-1">
                        <div>
                            <h3 class="font-bold text-gray-800 text-sm line-clamp-1"><?php echo e($item['name']); ?></h3>
                            <p class="text-xs text-gray-500"><?php echo e($item['variant_name']); ?></p>
                        </div>
                        <div class="flex justify-between items-end">
                            <span class="font-bold text-rose-500"><?php echo format_price($item['price']); ?></span>
                            <!-- Qty Control -->
                            <div class="flex items-center bg-gray-100 rounded-lg px-2 py-1 gap-3">
                                <button class="text-gray-500 font-bold">-</button>
                                <span class="text-xs font-bold w-4 text-center"><?php echo $item['quantity']; ?></span>
                                <button class="text-gray-800 font-bold">+</button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <!-- Totals -->
            <div class="mt-8 bg-white p-6 rounded-2xl shadow-sm">
                <div class="flex justify-between mb-2 text-sm text-gray-500">
                    <span>Subtotal</span>
                    <span><?php echo format_price($total); ?></span>
                </div>
                <div class="flex justify-between mb-4 text-sm text-gray-500">
                    <span>Shipping</span>
                    <span class="text-green-500 font-bold">Free</span>
                </div>
                <div class="border-t border-dashed border-gray-200 my-4"></div>
                <div class="flex justify-between text-lg font-bold text-gray-900">
                    <span>Total</span>
                    <span><?php echo format_price($total); ?></span>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php if(!empty($cartItems)): ?>
    <!-- Checkout Bar -->
    <div class="fixed bottom-0 left-0 w-full bg-white border-t border-gray-100 p-4 safe-pb z-50">
        <a href="checkout.php" class="block w-full bg-gray-900 text-white text-center font-bold py-4 rounded-xl shadow-lg active:scale-95 transition-transform">
            Proceed to Checkout
        </a>
    </div>
    <?php endif; ?>

</body>
</html>
