<?php
// public_html/user/auth/otp-verify.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';

if (!isset($_GET['phone'])) {
    redirect('/user/auth/login-signup.php');
}

$phone = e($_GET['phone']);
$pageTitle = 'Verify OTP';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Verify | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen flex flex-col items-center justify-center p-6">
    
    <div class="w-full max-w-sm text-center">
        <h2 class="text-2xl font-bold text-gray-900 mb-2">Verify Mobile</h2>
        <p class="text-gray-500 text-sm mb-8">Enter the 6-digit code sent to <br><span class="font-bold text-gray-800">+91 <?php echo $phone; ?></span></p>

        <form id="otpForm" class="space-y-6">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="phone" value="<?php echo $phone; ?>">
            
            <div class="flex justify-center gap-2">
                <?php for($i=0; $i<6; $i++): ?>
                <input type="tel" maxlength="1" class="otp-input w-12 h-12 border-2 border-gray-200 rounded-xl text-center text-xl font-bold text-gray-800 focus:border-rose-500 focus:bg-rose-50 outline-none transition-all" required>
                <?php endfor; ?>
                <!-- Hidden input for full OTP -->
                <input type="hidden" name="otp" id="fullOtp">
            </div>

            <button type="submit" id="verifyBtn" class="w-full bg-rose-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-rose-200 active:scale-95 transition-transform">
                Verify & Login
            </button>

            <div id="feedback" class="text-sm font-bold text-red-500 hidden"></div>
        </form>

        <div class="mt-8">
            <p class="text-gray-400 text-sm" id="timerMsg">Resend code in <span id="timer" class="font-bold text-gray-600">00:30</span></p>
            <button id="resendBtn" class="hidden text-rose-500 font-bold text-sm hover:underline">Resend OTP</button>
        </div>
    </div>

    <script>
        const inputs = document.querySelectorAll('.otp-input');
        const submitBtn = document.getElementById('verifyBtn');
        const feedback = document.getElementById('feedback');
        
        // Auto-focus logic
        inputs.forEach((input, index) => {
            input.addEventListener('input', (e) => {
                const val = e.target.value;
                if (val.length === 1 && index < 5) {
                    inputs[index + 1].focus();
                } else if (val.length === 0 && index > 0) {
                    inputs[index - 1].focus(); // Backspace support (if empty)
                }
                
                // Collect OTP
                let otp = '';
                inputs.forEach(i => otp += i.value);
                document.getElementById('fullOtp').value = otp;
            });

            input.addEventListener('keydown', (e) => {
                if(e.key === 'Backspace' && e.target.value === '' && index > 0) {
                     inputs[index - 1].focus();
                }
            });
        });

        // Timer
        let timeLeft = 30;
        const timerEl = document.getElementById('timer');
        const resendBtn = document.getElementById('resendBtn');
        const timerMsg = document.getElementById('timerMsg');
        
        const countdown = setInterval(() => {
            timeLeft--;
            timerEl.innerText = `00:${timeLeft < 10 ? '0' : ''}${timeLeft}`;
            if (timeLeft <= 0) {
                clearInterval(countdown);
                timerMsg.classList.add('hidden');
                resendBtn.classList.remove('hidden');
            }
        }, 1000);

        // Submit Logic
        document.getElementById('otpForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            feedback.classList.add('hidden');
            submitBtn.innerText = 'Verifying...';
            submitBtn.disabled = true;

            const formData = new FormData(e.target);
            formData.append('scout_action', 'verify_otp');

            try {
                const res = await fetch('<?php echo APP_URL; ?>/api/user/auth.php', {
                    method: 'POST',
                    body: formData,
                    headers: {'X-Requested-With': 'XMLHttpRequest'}
                });
                
                const data = await res.json();
                
                if (data.success) {
                    window.location.href = '<?php echo APP_URL; ?>/user/home.php';
                } else {
                    throw new Error(data.error || 'Invalid OTP');
                }

            } catch (err) {
                feedback.innerText = err.message;
                feedback.classList.remove('hidden');
                submitBtn.innerText = 'Verify & Login';
                submitBtn.disabled = false;
            }
        });
    </script>
</body>
</html>
