<?php
// public_html/user/auth/logout.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';

// Initialize session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Unset all session variables
$_SESSION = [];

// Delete the session cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy session
session_destroy();

// Redirect
header("Location: " . APP_URL . "/user/auth/login-signup.php");
exit;
