<?php
// public_html/user/auth/login-signup.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php'; // Bootstrap

// If logged in, redirect home
if (isset($_SESSION['user_id'])) {
    redirect('/user/home.php');
}

$pageTitle = 'Login or Signup';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo $pageTitle; ?> | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
        body { background-color: #FFF5F7; } /* Cream background */
    </style>
</head>
<body class="bg-rose-50 min-h-screen flex items-center justify-center p-4">

    <div class="w-full max-w-sm bg-white rounded-3xl shadow-xl overflow-hidden relative">
        <!-- Top Visual -->
        <div class="h-32 bg-rose-500 rounded-b-[50%] absolute top-0 w-full z-0 p-6 text-center">
            <h1 class="text-white text-2xl font-bold mt-2">Welcome</h1>
            <p class="text-rose-100 text-sm">Beauty & Fashion Store</p>
        </div>

        <div class="relative z-10 mt-24 px-6 pb-8">
            <div class="bg-white rounded-2xl p-2 shadow-sm mb-6 text-center">
                <img src="https://cdn-icons-png.flaticon.com/512/2830/2830305.png" alt="Logo" class="w-16 h-16 mx-auto -mt-10 bg-white rounded-full p-1 border-4 border-white shadow-md">
            </div>

            <!-- Form -->
            <form id="authForm" class="space-y-4">
                <?php echo csrf_field(); ?>
                
                <div>
                    <label class="block text-gray-500 text-xs font-bold uppercase mb-1 ml-2">Mobile Number</label>
                    <div class="flex items-center bg-gray-50 border border-gray-200 rounded-xl px-4 py-3 focus-within:ring-2 focus-within:ring-rose-500 transition-all">
                        <span class="text-gray-400 font-bold border-r border-gray-300 pr-3 mr-3">+91</span>
                        <input type="tel" name="phone" id="phone" placeholder="9876543210" maxlength="10" 
                               class="bg-transparent border-none outline-none w-full font-bold text-gray-800 tracking-widest text-lg placeholder-gray-300">
                    </div>
                </div>

                <!-- Referral Toggle -->
                <div class="pt-2">
                    <button type="button" id="toggleReferral" class="text-rose-500 text-sm font-bold flex items-center gap-1 hover:text-rose-600 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                        Have a referral code?
                    </button>
                    
                    <div id="referralContainer" class="hidden mt-2 transition-all">
                        <input type="text" name="referral_code" placeholder="Enter Code (e.g. LISA20)" 
                               class="w-full bg-gray-50 border border-gray-200 rounded-xl px-4 py-3 text-sm font-bold uppercase tracking-wide outline-none focus:border-rose-500">
                    </div>
                </div>

                <div class="pt-4">
                    <button type="submit" id="submitBtn" class="w-full bg-rose-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-rose-200 active:scale-95 transition-transform disabled:opacity-50 disabled:cursor-not-allowed">
                        Continue
                    </button>
                </div>

                <div id="feedback" class="text-center text-sm font-bold hidden"></div>
            </form>

            <p class="text-center text-xs text-gray-400 mt-6">
                By continuing, you agree to our <a href="#" class="underline">Terms</a> & <a href="#" class="underline">Privacy</a>.
            </p>
        </div>
    </div>

    <!-- Script -->
    <script>
        const phoneInput = document.getElementById('phone');
        const submitBtn = document.getElementById('submitBtn');
        const toggleRef = document.getElementById('toggleReferral');
        const refContainer = document.getElementById('referralContainer');
        const feedback = document.getElementById('feedback');

        // Toggle Referral
        toggleRef.addEventListener('click', () => {
            refContainer.classList.toggle('hidden');
            // Logic to focus if shown
            if(!refContainer.classList.contains('hidden')) {
                refContainer.querySelector('input').focus();
            }
        });

        // Basic Validation
        phoneInput.addEventListener('input', (e) => {
            e.target.value = e.target.value.replace(/\D/g, '').substring(0, 10);
            if (e.target.value.length === 10) {
                submitBtn.removeAttribute('disabled');
                submitBtn.classList.add('bg-rose-600');
            } else {
                submitBtn.setAttribute('disabled', 'true');
                submitBtn.classList.remove('bg-rose-600');
            }
        });

        // Submit Handler
        document.getElementById('authForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            // UI Loading State
            const originalText = submitBtn.innerText;
            submitBtn.innerText = 'Processing...';
            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-75', 'cursor-not-allowed');
            feedback.classList.add('hidden');

            const formData = new FormData(e.target);
            formData.append('scout_action', 'send_otp'); // Action for API

            try {
                const res = await fetch('<?php echo APP_URL; ?>/api/user/auth.php', {
                    method: 'POST',
                    body: formData,
                    headers: { 'X-Requested-With': 'XMLHttpRequest' }
                });

                const data = await res.json();

                if (data.success) {
                    // Redirect to OTP Verify
                    window.location.href = 'otp-verify.php?phone=' + formData.get('phone');
                } else {
                    throw new Error(data.error || 'Something went wrong');
                }

            } catch (err) {
                feedback.innerText = err.message;
                feedback.className = 'text-center text-sm font-bold mt-2 text-red-500 block';
                submitBtn.innerText = originalText;
                submitBtn.disabled = false;
                submitBtn.classList.remove('opacity-75');
            }
        });
    </script>
</body>
</html>
