<?php
// public_html/user/account/ticket-view.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$ticketId = $_GET['id'] ?? null;
$supportModel = new Support($pdo);
$data = $supportModel->getTicket($ticketId, $_SESSION['user_id']);

if (!$data) redirect('support.php');
$ticket = $data['info'];
$messages = $data['messages'];

$pageTitle = 'Ticket #' . $ticketId;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Chat | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .chat-scroll::-webkit-scrollbar { width: 4px; }
        .chat-scroll::-webkit-scrollbar-thumb { background: #e5e7eb; border-radius: 4px; }
    </style>
</head>
<body class="bg-gray-100 flex flex-col h-screen">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm flex items-center gap-4 shrink-0">
        <button onclick="history.back()" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></button>
        <div class="flex-1">
            <h1 class="font-bold text-gray-800 text-sm"><?php echo e($ticket['subject']); ?></h1>
            <p class="text-xs text-gray-500">Ticket #<?php echo $ticket['id']; ?></p>
        </div>
        <?php if($ticket['status'] === 'closed'): ?>
            <span class="text-xs font-bold text-red-500 bg-red-50 px-2 py-1 rounded">CLOSED</span>
        <?php else: ?>
            <span class="text-xs font-bold text-green-500 bg-green-50 px-2 py-1 rounded-full uppercase"><?php echo $ticket['status']; ?></span>
        <?php endif; ?>
    </div>

    <!-- Messages -->
    <div class="flex-1 overflow-y-auto chat-scroll p-4 space-y-4" id="chatBox">
        <?php foreach($messages as $msg): ?>
            <?php $isMe = $msg['sender'] === 'user'; ?>
            <div class="flex <?php echo $isMe ? 'justify-end' : 'justify-start'; ?>">
                <div class="max-w-[80%] <?php echo $isMe ? 'bg-rose-500 text-white rounded-l-2xl rounded-tr-2xl' : 'bg-white text-gray-800 rounded-r-2xl rounded-tl-2xl shadow-sm'; ?> p-3 text-sm">
                    <?php if($msg['attachment']): ?>
                        <img src="<?php echo e($msg['attachment']); ?>" class="w-full rounded-lg mb-2">
                    <?php endif; ?>
                    <p class="leading-relaxed"><?php echo nl2br(e($msg['message'])); ?></p>
                    <p class="text-[9px] mt-1 <?php echo $isMe ? 'text-rose-200 text-right' : 'text-gray-400'; ?>">
                        <?php echo date('h:i A', strtotime($msg['created_at'])); ?>
                    </p>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Input -->
    <?php if($ticket['status'] !== 'closed'): ?>
    <div class="bg-white p-3 border-t border-gray-200 shrink-0">
        <form id="replyForm" class="flex gap-2">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="ticket_id" value="<?php echo $ticket['id']; ?>">
            
            <input type="text" name="message" placeholder="Type a message..." required class="flex-1 bg-gray-100 rounded-full px-4 py-3 outline-none focus:ring-1 focus:ring-rose-500 text-sm">
            
            <button type="submit" class="bg-rose-500 text-white w-12 h-12 rounded-full flex items-center justify-center shadow-lg active:scale-95 transition-transform">
                <svg class="w-5 h-5 ml-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
            </button>
        </form>
    </div>
    <?php else: ?>
    <div class="bg-gray-200 p-4 text-center text-xs text-gray-500 font-bold uppercase shrink-0">
        This ticket is closed
    </div>
    <?php endif; ?>

    <script>
        const chatBox = document.getElementById('chatBox');
        chatBox.scrollTop = chatBox.scrollHeight;

        document.getElementById('replyForm')?.addEventListener('submit', async function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'reply_ticket');

            try {
                const res = await fetch('../../api/user/support.php', {
                    method: 'POST',
                    body: formData
                });
                const data = await res.json();
                if(data.success) {
                    window.location.reload();
                } else {
                    alert(data.error);
                }
            } catch(err) {
                console.error(err);
            }
        });
    </script>
</body>
</html>
