<?php
// public_html/user/account/support.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$supportModel = new Support($pdo);
$tickets = $supportModel->getUserTickets($_SESSION['user_id']);

$pageTitle = 'Help & Support';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Support | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <a href="../profile.php" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></a>
        <h1 class="font-bold text-lg">Help & Support</h1>
    </div>

    <!-- Create Ticket Card -->
    <div class="p-4">
        <div class="bg-white p-6 rounded-2xl shadow-sm mb-6">
            <h2 class="font-bold text-gray-800 mb-4">Create New Ticket</h2>
            <form id="createTicketForm" class="space-y-4">
                <?php echo csrf_field(); ?>
                
                <input type="text" name="subject" placeholder="Subject (e.g. Order Missing)" required 
                       class="w-full p-3 bg-gray-50 rounded-xl outline-none focus:ring-2 focus:ring-rose-500 transition-all font-medium border border-gray-100">
                
                <textarea name="message" placeholder="Describe your issue..." rows="3" required
                          class="w-full p-3 bg-gray-50 rounded-xl outline-none focus:ring-2 focus:ring-rose-500 transition-all font-medium border border-gray-100"></textarea>
                
                <div class="flex items-center gap-2 text-sm text-gray-500">
                    <label class="cursor-pointer bg-gray-100 px-3 py-2 rounded-lg font-bold hover:bg-gray-200 transition-colors">
                        <input type="file" name="attachment" class="hidden" accept="image/*">
                        <span>Attach Image</span>
                    </label>
                    <span id="fileName" class="truncate text-xs"></span>
                </div>

                <button type="submit" class="w-full bg-rose-500 text-white font-bold py-3 rounded-xl shadow-lg shadow-rose-200 active:scale-95 transition-transform">
                    Submit Ticket
                </button>
            </form>
        </div>

        <!-- Ticket List -->
        <h3 class="font-bold text-gray-800 mb-3 ml-1">Your Tickets</h3>
        <?php if(empty($tickets)): ?>
            <p class="text-center text-gray-400 py-4 text-sm">No tickets yet.</p>
        <?php else: ?>
            <div class="space-y-3">
                <?php foreach($tickets as $ticket): ?>
                <a href="ticket-view.php?id=<?php echo $ticket['id']; ?>" class="block bg-white p-4 rounded-xl shadow-sm active:scale-95 transition-transform">
                    <div class="flex justify-between items-start mb-1">
                        <span class="font-bold text-gray-800 text-sm">#<?php echo $ticket['id']; ?> - <?php echo e($ticket['subject']); ?></span>
                        <?php
                            $statusColor = 'bg-gray-100 text-gray-500'; // Open
                            if($ticket['status'] == 'replied') $statusColor = 'bg-green-100 text-green-600';
                            if($ticket['status'] == 'closed') $statusColor = 'bg-red-100 text-red-600';
                        ?>
                        <span class="px-2 py-0.5 rounded text-[10px] font-bold uppercase <?php echo $statusColor; ?>">
                            <?php echo $ticket['status']; ?>
                        </span>
                    </div>
                    <p class="text-xs text-gray-500 truncate mb-2"><?php echo e($ticket['last_message'] ?? 'No messages'); ?></p>
                    <p class="text-[10px] text-gray-400 text-right"><?php echo date('d M, h:i A', strtotime($ticket['updated_at'])); ?></p>
                </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- JS for Create Ticket -->
    <script>
        document.querySelector('input[type="file"]').addEventListener('change', function(){
            document.getElementById('fileName').innerText = this.files[0] ? this.files[0].name : '';
        });

        document.getElementById('createTicketForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'create_ticket');

            try {
                const res = await fetch('../../api/user/support.php', {
                    method: 'POST',
                    body: formData
                });
                const data = await res.json();
                
                if(data.success) {
                    alert('Ticket Created!'); // Or Use Popup.show if available globally
                    window.location.reload();
                } else {
                    alert(data.error || 'Failed to create ticket');
                }
            } catch(err) {
                console.error(err);
                alert('Something went wrong');
            }
        });
    </script>
    
    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
