<?php
// public_html/user/account/notifications.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Notification.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$notifModel = new Notification($pdo);
$notifications = $notifModel->getUserNotifications($_SESSION['user_id']);

// Auto Mark all as read when visiting this page
$notifModel->markAllRead($_SESSION['user_id']);

$pageTitle = 'Notifications';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Notifications | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#FFF7F2] pb-24">
    <!-- Header -->
    <div class="bg-white p-4 shadow-sm sticky top-0 z-10 flex items-center gap-4">
        <a href="../profile.php" class="text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></a>
        <h1 class="font-bold text-lg">Notifications</h1>
    </div>

    <div class="p-4 space-y-3">
        <?php if(empty($notifications)): ?>
            <div class="text-center py-20 text-gray-400">
                <svg class="w-16 h-16 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path></svg>
                <p>No new notifications</p>
            </div>
        <?php else: ?>
            <?php foreach($notifications as $n): ?>
            <div class="bg-white p-4 rounded-2xl shadow-sm flex gap-4 <?php echo $n['is_read'] ? 'opacity-80' : 'border-l-4 border-rose-500'; ?>">
                <div class="w-10 h-10 rounded-full bg-rose-50 flex items-center justify-center text-rose-500 shrink-0">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <div>
                    <h3 class="font-bold text-gray-800 text-sm mb-1"><?php echo e($n['title']); ?></h3>
                    <p class="text-xs text-gray-500 leading-relaxed"><?php echo e($n['message']); ?></p>
                    <p class="text-[10px] text-gray-400 mt-2"><?php echo date('d M, h:i A', strtotime($n['created_at'])); ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <?php require_once ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
