<?php
// public_html/search.php
require_once dirname(__DIR__) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Product.php';
require_once ROOT_PATH . '/templates/components/skeletons.php';

$query = $_GET['q'] ?? '';
$catId = $_GET['cat'] ?? '';

$results = [];
if ($query || $catId) {
    $productModel = new Product();
    // Simplified search logic for prototype
    $results = $productModel->search($query); 
}
$pageTitle = 'Search';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Search | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-20">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <div class="px-4">
        <form class="mb-6">
            <div class="relative">
                <input type="text" name="q" value="<?php echo htmlspecialchars($query); ?>" placeholder="Search products..." class="w-full bg-white px-4 py-3 rounded-xl shadow-sm border border-gray-100 outline-none focus:border-rose-500 pl-10">
                <svg class="w-5 h-5 text-gray-400 absolute left-3 top-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/></svg>
            </div>
        </form>

        <div class="grid grid-cols-2 gap-4">
            <?php foreach($results as $p): ?>
                <a href="/public_html/product.php?slug=<?php echo $p['slug']; ?>" class="bg-white rounded-xl overflow-hidden shadow-sm border border-gray-100">
                    <img src="<?php echo $p['image_url']; ?>" class="w-full aspect-[3/4] object-cover">
                    <div class="p-3">
                        <h3 class="text-sm font-medium line-clamp-1"><?php echo $p['name']; ?></h3>
                        <p class="font-bold text-gray-900 mt-1"><?php echo formatPrice($p['sale_price'] ?: $p['base_price']); ?></p>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
        
        <?php if(empty($results) && $query): ?>
            <p class="text-center text-gray-500 mt-10">No results found for "<?php echo htmlspecialchars($query); ?>"</p>
        <?php endif; ?>
    </div>
    
    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
