<?php
// public_html/product.php
require_once dirname(__DIR__) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Product.php';

$slug = $_GET['slug'] ?? '';
$productModel = new Product();
$p = $productModel->getBySlug($slug);

if (!$p) {
    echo "Product not found"; // Ideally 404 page
    exit;
}

$pageTitle = substr($p['name'], 0, 20) . '...';
$showBackButton = true;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo $p['name']; ?> | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>.hide-scrollbar::-webkit-scrollbar { display: none; }</style>
</head>
<body class="bg-gray-50 pb-24">

    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- Image -->
    <div class="w-full aspect-[3/4] bg-white relative">
        <img src="<?php echo $p['image_url']; ?>" class="w-full h-full object-cover">
    </div>

    <!-- Info -->
    <div class="px-4 py-6 bg-white -mt-4 rounded-t-3xl relative z-10 shadow-[0_-4px_6px_-1px_rgba(0,0,0,0.05)]">
        <div class="flex justify-between items-start mb-2">
            <div>
                 <p class="text-sm text-gray-500"><?php echo $p['category_name']; ?></p>
                 <h1 class="text-2xl font-bold text-gray-900"><?php echo $p['name']; ?></h1>
            </div>
            <div class="text-right">
                <p class="text-2xl font-bold text-rose-500"><?php echo formatPrice($p['sale_price'] ?: $p['base_price']); ?></p>
            </div>
        </div>

        <!-- Variants -->
        <?php if(!empty($p['variants'])): ?>
        <div class="mt-6">
            <h3 class="text-sm font-medium text-gray-900 mb-3">Select Variant</h3>
            <div class="flex flex-wrap gap-2">
                <?php foreach($p['variants'] as $v): ?>
                <button onclick="selectVariant(this, <?php echo $v['id']; ?>, <?php echo $v['stock_quantity']; ?>)" 
                        class="variant-btn px-4 py-2 rounded-lg border border-gray-200 text-sm font-medium hover:border-rose-500 transition-colors <?php echo $v['stock_quantity'] == 0 ? 'opacity-50 cursor-not-allowed' : ''; ?>">
                    <?php echo $v['color_name'] . ' - ' . $v['size']; ?>
                </button>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Desc -->
        <div class="mt-8">
            <h3 class="text-sm font-medium text-gray-900 mb-2">Description</h3>
            <div class="text-gray-600 text-sm leading-relaxed">
                <?php echo $p['description']; ?>
            </div>
        </div>
    </div>

    <!-- Sticky Bottom Bar -->
    <div class="fixed bottom-0 w-full bg-white border-t border-gray-100 p-4 pb-safe flex items-center gap-4 z-50">
        <!-- Wishlist -->
        <button class="p-3 rounded-xl bg-gray-100 text-gray-500 hover:text-rose-500">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
        </button>

        <!-- Add to Cart -->
        <button onclick="addToCart()" id="add-btn" class="flex-1 bg-rose-500 text-white font-bold py-3 rounded-xl shadow-lg shadow-rose-200 disabled:opacity-50 disabled:cursor-not-allowed">
            Add to Cart
        </button>
    </div>

    <!-- Toast Logic included via Header or similar, strictly simple here -->
    <script>
        let selectedVariantId = null;

        function selectVariant(btn, id, stock) {
            if (stock === 0) return;
            selectedVariantId = id;
            
            // UI Update
            document.querySelectorAll('.variant-btn').forEach(b => {
                b.classList.remove('bg-rose-50', 'border-rose-500', 'text-rose-600');
                b.classList.add('border-gray-200');
            });
            btn.classList.remove('border-gray-200');
            btn.classList.add('bg-rose-50', 'border-rose-500', 'text-rose-600');
        }

        async function addToCart() {
            <?php if(empty($p['variants'])): ?>
                // If no variants, assume logic? Or force variant? 
                // For simplicity, we assume fashion always has variants. If not, hidden variant logic required.
                alert("Please select a variant"); // Detailed logic omitted
            <?php else: ?>
                if (!selectedVariantId) {
                    alert('Please select a size/color');
                    return;
                }
            <?php endif; ?>

            const btn = document.getElementById('add-btn');
            btn.innerHTML = 'Adding...';
            btn.disabled = true;

            try {
                const fd = new FormData();
                fd.append('action', 'add');
                fd.append('variant_id', selectedVariantId);
                
                const res = await fetch('/public_html/api/cart_action.php', { method: 'POST', body: fd, headers: {'X-Requested-With': 'XMLHttpRequest'} });
                const data = await res.json();
                
                if (data.success) {
                    btn.innerHTML = 'Added!';
                    setTimeout(() => { btn.innerHTML = 'Add to Cart'; btn.disabled = false; }, 2000);
                    // Update Cart badge ideally
                } else {
                    alert(data.error || 'Error');
                    if (data.redirect) window.location.href = data.redirect;
                    btn.disabled = false;
                }
            } catch(e) {
                alert('Network Error');
                btn.disabled = false;
            }
        }
    </script>
</body>
</html>
