<?php
// public_html/maintenance.php
require_once __DIR__ . '/../config/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Under Maintenance | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes pulse { 0%, 100% { opacity: 1; } 50% { opacity: .5; } }
        .u-pulse { animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
    </style>
</head>
<body class="bg-gray-50 h-screen flex flex-col items-center justify-center text-center p-6">
    
    <div class="mb-8">
        <div class="w-20 h-20 bg-rose-100 rounded-full flex items-center justify-center mx-auto mb-4 u-pulse">
            <svg class="w-10 h-10 text-rose-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path></svg>
        </div>
        <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo SITE_NAME; ?></h1>
        <p class="text-sm text-gray-500 font-medium tracking-widest uppercase">Under Maintenance</p>
    </div>

    <div class="max-w-md bg-white p-8 rounded-2xl shadow-xl shadow-gray-100 border border-gray-100">
        <h2 class="text-xl font-bold text-gray-800 mb-4">We're Upgrading!</h2>
        <p class="text-gray-600 mb-6 leading-relaxed">
            We are currently updating our system to provide you with a better shopping experience. 
            We should be back shortly.
        </p>

        <button onclick="window.location.reload()" class="w-full bg-gray-900 text-white font-bold py-4 rounded-xl hover:bg-black transition-transform active:scale-95">
            Check Again
        </button>
    </div>

    <p class="mt-8 text-xs text-gray-400">&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>

</body>
</html>
