<?php
// public_html/home.php
require_once dirname(__DIR__) . '/public_html/index.php'; // Bootstrap
require_once ROOT_PATH . '/src/Models/Product.php';
require_once ROOT_PATH . '/templates/components/skeletons.php';

$productModel = new Product();
$categories = $productModel->getCategories();
$featured = $productModel->getFeatured(8);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Home | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>.hide-scrollbar::-webkit-scrollbar { display: none; } .hide-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }</style>
</head>
<body class="bg-gray-50 pb-20">

    <!-- Header -->
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <!-- Search Bar (Fake Input to go to Search Page) -->
    <div class="px-4 mt-4">
        <a href="/public_html/search.php" class="block w-full bg-white rounded-xl shadow-sm border border-gray-100 px-4 py-3 text-gray-400 flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/></svg>
            <span>Search for lipstick, dress...</span>
        </a>
    </div>

    <!-- Categories (Stories Style) -->
    <div class="mt-6">
        <div class="flex gap-4 overflow-x-auto hide-scrollbar px-4 pb-2">
            <?php foreach($categories as $cat): ?>
            <a href="/public_html/search.php?cat=<?php echo $cat['id']; ?>" class="flex flex-col items-center gap-2 min-w-[70px]">
                <div class="w-16 h-16 rounded-full p-[2px] bg-gradient-to-tr from-rose-400 to-purple-500">
                    <img src="<?php echo $cat['image_url'] ?: 'https://via.placeholder.com/60'; ?>" class="w-full h-full rounded-full object-cover border-2 border-white">
                </div>
                <span class="text-xs font-medium text-gray-700 truncate w-full text-center"><?php echo $cat['name']; ?></span>
            </a>
            <?php endforeach; ?>
            <!-- Fallback if empty -->
            <?php if(empty($categories)) renderCategorySkeleton(5); ?>
        </div>
    </div>

    <!-- Featured Section -->
    <div class="px-4 mt-8">
        <div class="flex justify-between items-end mb-4">
            <h2 class="text-xl font-bold text-gray-900">Trending Now</h2>
            <a href="/public_html/search.php" class="text-sm text-rose-500 font-medium">See All</a>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <?php foreach($featured as $p): ?>
            <a href="/public_html/product.php?slug=<?php echo $p['slug']; ?>" class="group block bg-white rounded-xl overflow-hidden shadow-sm border border-gray-100">
                <div class="aspect-[3/4] relative overflow-hidden bg-gray-100">
                    <img src="<?php echo $p['image_url'] ?: 'https://via.placeholder.com/300x400'; ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                </div>
                <div class="p-3">
                    <h3 class="text-sm text-gray-900 font-medium truncate"><?php echo $p['name']; ?></h3>
                    <p class="text-xs text-gray-500 mb-1"><?php echo $p['category_name']; ?></p>
                    <div class="flex items-center gap-2">
                        <span class="text-sm font-bold text-gray-900"><?php echo formatPrice($p['sale_price'] ?: $p['base_price']); ?></span>
                        <?php if($p['sale_price']): ?>
                            <span class="text-xs text-gray-400 line-through"><?php echo formatPrice($p['base_price']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
            
            <?php if(empty($featured)) renderProductCardSkeleton(4); ?>
        </div>
    </div>

    <!-- Bottom Nav -->
    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>

</body>
</html>
