<?php
// public_html/checkout.php
require_once dirname(__DIR__) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Cart.php';
require_once ROOT_PATH . '/src/Models/Order.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$cart = new Cart();
$cartData = $cart->get($_SESSION['user_id']);

if ($cartData['count'] == 0) redirect('/public_html/cart.php');

// Handle Post
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect Address
    $address = [
        'line1' => sanitize($_POST['address']),
        'city' => sanitize($_POST['city']),
        'zip' => sanitize($_POST['zip'])
    ];
    $payment = sanitize($_POST['payment']);
    
    $order = new Order();
    $result = $order->create($_SESSION['user_id'], json_encode($address), $payment, $cartData);
    
    if (isset($result['success'])) {
        $cart->clear($_SESSION['user_id']);
        $_SESSION['cart_count'] = 0;
        redirect('/public_html/order-success.php?id=' . $result['order_number']);
    } else {
        $error = $result['error'];
    }
}

$pageTitle = 'Checkout';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Checkout | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-20">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>
    
    <?php if(isset($error)): ?>
        <div class="bg-red-100 text-red-700 p-4 m-4 rounded-xl"><?php echo $error; ?></div>
    <?php endif; ?>

    <form method="POST" class="px-4 space-y-6">
        
        <!-- Address -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <h3 class="font-bold text-gray-900 mb-4">Shipping Address</h3>
            <div class="space-y-3">
                <input type="text" name="address" placeholder="Street Address" required class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg outline-none focus:border-rose-500">
                <div class="flex gap-3">
                    <input type="text" name="city" placeholder="City" required class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg outline-none focus:border-rose-500">
                    <input type="text" name="zip" placeholder="ZIP" required class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg outline-none focus:border-rose-500">
                </div>
            </div>
        </div>

        <!-- Payment -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <h3 class="font-bold text-gray-900 mb-4">Payment Method</h3>
            <div class="space-y-3">
                <label class="flex items-center gap-3 p-3 border border-gray-200 rounded-lg cursor-pointer hover:border-rose-500">
                    <input type="radio" name="payment" value="cod" checked class="text-rose-500 focus:ring-rose-500">
                    <span>Cash on Delivery</span>
                </label>
                <label class="flex items-center gap-3 p-3 border border-gray-200 rounded-lg cursor-pointer hover:border-rose-500">
                    <input type="radio" name="payment" value="wallet" class="text-rose-500 focus:ring-rose-500">
                    <span>Pay via Wallet</span>
                </label>
            </div>
        </div>
        
        <!-- Summary -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="flex justify-between font-bold text-lg">
                <span>Total to Pay</span>
                <span><?php echo formatPrice($cartData['total']); ?></span>
            </div>
        </div>

        <button type="submit" class="w-full bg-rose-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-rose-200">
            Place Order
        </button>
    </form>
</body>
</html>
