<?php
// public_html/cart.php
require_once dirname(__DIR__) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Cart.php';

if (!isset($_SESSION['user_id'])) redirect('/user/auth/login-signup.php');

$cart = new Cart();
$cartData = $cart->get($_SESSION['user_id']);
$items = $cartData['items'];
$pageTitle = 'Shopping Bag';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Cart | <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 pb-24">
    <?php include ROOT_PATH . '/templates/components/header.php'; ?>

    <?php if(empty($items)): ?>
    <div class="flex flex-col items-center justify-center min-h-[60vh] px-6 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mb-4">
            <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/></svg>
        </div>
        <h2 class="text-xl font-bold text-gray-900 mb-2">Your bags are empty</h2>
        <p class="text-gray-500 mb-8">Looks like you haven't added anything to your cart yet.</p>
        <a href="/public_html/home.php" class="bg-rose-500 text-white font-bold px-8 py-3 rounded-xl shadow-lg shadow-rose-200">Start Shopping</a>
    </div>
    <?php else: ?>
    
    <div class="px-4 py-4 space-y-4">
        <?php foreach($items as $item): ?>
        <div class="flex gap-4 p-4 bg-white rounded-xl shadow-sm border border-gray-100 relative" id="item-<?php echo $item['item_id']; ?>">
            <img src="<?php echo $item['image_url']; ?>" class="w-20 h-24 object-cover rounded-lg bg-gray-100 shrink-0">
            <div class="flex-1">
                <h3 class="text-sm font-medium text-gray-900 line-clamp-2 mb-1"><?php echo $item['name']; ?></h3>
                <p class="text-xs text-gray-500 mb-2"><?php echo $item['color_name']; ?> | Size <?php echo $item['size']; ?></p>
                <div class="flex justify-between items-end">
                    <span class="font-bold text-gray-900"><?php echo formatPrice($item['price']); ?></span>
                    <button onclick="removeItem(<?php echo $item['item_id']; ?>)" class="text-xs text-red-500 font-medium p-2 hover:bg-red-50 rounded">Remove</button>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- Summary -->
    <div class="fixed bottom-0 w-full bg-white border-t border-gray-100 p-4 pb-safe z-40">
        <div class="flex justify-between items-center mb-4">
            <span class="text-gray-500">Total</span>
            <span class="text-xl font-bold text-gray-900"><?php echo formatPrice($cartData['total']); ?></span>
        </div>
        <a href="/public_html/checkout.php" class="block w-full text-center bg-rose-500 text-white font-bold py-3 rounded-xl shadow-lg shadow-rose-200">
            Proceed to Checkout
        </a>
    </div>
    
    <script>
        async function removeItem(id) {
            if(!confirm('Remove item?')) return;
            const fd = new FormData();
            fd.append('action', 'remove');
            fd.append('item_id', id);
            
            const res = await fetch('/public_html/api/cart_action.php', { method: 'POST', body: fd, headers: {'X-Requested-With': 'XMLHttpRequest'} });
            if(res.ok) window.location.reload();
        }
    </script>
    <?php endif; ?>
    <!-- Includes bottom nav as backup -->
    <?php include ROOT_PATH . '/templates/components/bottom-nav.php'; ?>
</body>
</html>
