/**
 * Skeleton Loader Manager
 */
const Skeleton = {
    toggle(containerId, show) {
        const container = document.getElementById(containerId);
        if (!container) return;

        const skeletons = container.querySelectorAll('.skeleton-loader');
        const content = container.querySelectorAll('.real-content');

        if (show) {
            skeletons.forEach(el => el.classList.remove('hidden'));
            content.forEach(el => el.classList.add('hidden'));
        } else {
            skeletons.forEach(el => el.classList.add('hidden'));
            content.forEach(el => el.classList.remove('hidden'));
        }
    }
};
