<?php
// public_html/api/user/support.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Support.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();
    
    $action = $_POST['action'] ?? '';
    $userId = $_SESSION['user_id'];
    $supportModel = new Support($pdo);

    if ($action === 'create_ticket') {
        $subject = $_POST['subject'] ?? '';
        $message = $_POST['message'] ?? '';
        
        if (strlen($subject) < 3 || strlen($message) < 5) {
            echo json_encode(['error' => 'Please provide detailed subject and message']);
            exit;
        }

        // Mock File Upload (In Prod: Use proper upload handler)
        $imageUrl = null;
        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === 0) {
            // Ideally: upload to /uploads/tickets/
            // $imageUrl = '/uploads/tickets/' . basename($_FILES['attachment']['name']);
        }

        try {
            $id = $supportModel->createTicket($userId, $subject, $message, $imageUrl);
            echo json_encode(['success' => true, 'id' => $id]);
        } catch (Exception $e) {
            echo json_encode(['error' => $e->getMessage()]);
        }
    } 
    
    elseif ($action === 'reply_ticket') {
        $ticketId = $_POST['ticket_id'] ?? 0;
        $message = $_POST['message'] ?? '';

        if (!$ticketId || strlen($message) < 1) {
            echo json_encode(['error' => 'Invalid reply']);
            exit;
        }

        // Validate Ownership
        $ticket = $supportModel->getTicket($ticketId, $userId);
        if (!$ticket) {
            echo json_encode(['error' => 'Ticket not found']);
            exit;
        }

        try {
            $supportModel->addMessage($ticketId, $userId, $message, null, 'user');
            echo json_encode(['success' => true]);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to send']);
        }
    }
}
